<?php $__env->startSection('title', 'Brand Information'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Brand Information</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Show Brand</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Brand Information</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('brand/'.$brand->id.'/edit')); ?>" class="btn btn-info">
                        <i class="fas fa-edit"></i>
                        Edit
                    </a>
                    <a href="<?php echo e(routeHelper('brand')); ?>" class="btn btn-danger">
                        
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <tbody>
                    <tr>
                        <th>Cover Photo</th>
                        <td>
                            <?php if($brand->cover_photo == 'default.png'): ?>
                                <img src="https://via.placeholder.com/150" alt="Cover Photo" width="150px" height="150px"> 
                            <?php else: ?>
                                <img src="/uploads/brand/<?php echo e($brand->cover_photo); ?>" alt="Cover Photo" width="150px" height="150px">
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Name</th>
                        <td><?php echo e($brand->name); ?></td>
                    </tr>
                    <tr>
                        <th>Description</th>
                        <td><?php echo e($brand->description); ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td>
                            <?php if($brand->status): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Disable</span>
                            <?php endif; ?>    
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce2.elitedesign.com.bd/resources/views/admin/e-commerce/brand/show.blade.php ENDPATH**/ ?>