<?php $__env->startSection('title', 'Vendor List'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    <!-- DataTables  & Plugins -->
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="/assets/plugins/jszip/jszip.min.js"></script>
    <script src="/assets/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="/assets/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script>
        $(function () { 
            $("#example1").DataTable({
                "responsive": true,
                // "lengthChange": false,
                "paging": false, // Disable pagination
                "info": false, // Hide information element
                "searching": false, // Hide search input
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        })
    </script>
<?php $__env->stopPush(); ?>





<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Vendor List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Vendor List</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Vendor List</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('vendor/create')); ?>" class="btn btn-success">
                        <i class="fas fa-plus-circle"></i>
                        Add Vendor
                    </a>
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Amount</th>
                        <th>pending</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($data->name); ?></td>
                            <td><?php echo e($data->username); ?></td>
                            <td><?php echo e($data->email); ?></td>
                            <td><?php echo e($data->phone); ?></td>
                        
                            <td>
                                <?php if($data->is_approved==1): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Disable</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($data->vendorAccount->amount ?? 0); ?></td>
                            <td><?php echo e($data->vendorAccount->pending_amount ?? 0); ?></td>
                            <td style="position:relative;">
                                <?php if($data->is_approved==1): ?>
                                <a title="Disable" href="<?php echo e(routeHelper('user/status/'. $data->id)); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-lock-open"></i>
                                </a> 
                                <?php else: ?>
                                <a title="Active" href="<?php echo e(routeHelper('user/status/'. $data->id)); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-lock"></i>
                                </a> 
                                <?php endif; ?>
                                <a href="<?php echo e(route('admin.vendor.product',['vid'=>$data->id])); ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-store"></i>
                                </a>
                                <a href="<?php echo e(routeHelper('vendor/'. $data->id)); ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(routeHelper('vendor/'.$data->id.'/edit')); ?>" class="btn btn-info btn-sm">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="javascript:void(0)" data-id="<?php echo e($data->id); ?>" id="deleteData" class="btn btn-danger btn-sm"">
                                    <i class="nav-icon fas fa-trash-alt"></i>
                                </a>
                                <form id="delete-data-form-<?php echo e($data->id); ?>" action="<?php echo e(routeHelper('vendor/'. $data->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                </form>
                                <button class="btn btn-info btn-sm mt-2" onclick="action_vn(<?php echo e($data->id); ?>)">ACTION</button>
                                <div id="action_apply_vn_<?php echo e($data->id); ?>" style="display:none;background:var(--primary_color);padding:7px 10px;position:absolute;bottom:-30px;right:100%;width:90%;border-radius:4px;z-index:9999;">
                                    <a style="color:var(--secondary_color);" href="<?php echo e(route('admin.vendor.change_pass_index', ['id'=>$data->id])); ?>">Change Password</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php $__env->startPush('js'); ?><script>function action_vn(data_id){$(`#action_apply_vn_${data_id}`).toggle();}</script><?php $__env->stopPush(); ?>
                </tbody>
            </table>

            <?php echo e($vendors->firstItem()); ?> - <?php echo e($vendors->lastItem()); ?> of <?php echo e($vendors->total()); ?> results
            <nav aria-label="Page navigation example">
                <ul class="pagination">
                    
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($vendors->url(1)); ?>">First</a>
                    </li>
            
                    
                    <?php
                        $totalPages = ceil($vendors->total() / $vendors->perPage());
                        $currentPage = $vendors->currentPage();
                        $middlePage = floor($totalPages / 2);
                    ?>
            
                    <?php if($totalPages > 3): ?>
                        
                        <?php for($i = max($currentPage - 2, 2); $i < $currentPage; $i++): ?>
                            <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                <a class="page-link" href="<?php echo e($vendors->url($i)); ?>"><?php echo e($i); ?></a>
                            </li>
                        <?php endfor; ?>
            
                        
                        <li class="page-item active">
                            <a class="page-link" href="#"><?php echo e($currentPage); ?></a>
                        </li>
            
                        
                        <?php for($i = $currentPage + 1; $i <= min($currentPage + 2, $totalPages - 1); $i++): ?>
                            <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                <a class="page-link" href="<?php echo e($vendors->url($i)); ?>"><?php echo e($i); ?></a>
                            </li>
                        <?php endfor; ?>
            
                        
                        <li class="page-item">
                            <a class="page-link" href="<?php echo e($vendors->url($totalPages)); ?>">Last</a>
                        </li>
                    <?php else: ?>
                        
                        <?php for($i = 2; $i < $totalPages; $i++): ?>
                            <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                <a class="page-link" href="<?php echo e($vendors->url($i)); ?>"><?php echo e($i); ?></a>
                            </li>
                        <?php endfor; ?>
                    <?php endif; ?>
                    <?php if($vendors->nextPageUrl()): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($vendors->nextPageUrl()); ?>" aria-label="Next">
                                    <span aria-hidden="true">Next</span>
                                </a>
                            </li>
                        <?php endif; ?>
                </ul>
            </nav>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ofsbazar/public_html/resources/views/admin/e-commerce/vendor/index.blade.php ENDPATH**/ ?>