<?php $__env->startSection('title', 'Slider List'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Slider List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Slider List</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Slider List</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('slider/create')); ?>" class="btn btn-success">
                        <i class="fas fa-plus-circle"></i>
                        Add Size
                    </a>
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Image</th>
                        <th>Url</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td>
                                <img src="/uploads/slider/<?php echo e($data->image); ?>" alt="Slider" width="200px">
                            </td>
                            <td><?php echo e($data->url); ?></td>
                            <td>
                                <?php if($data->status): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Disable</span>
                                <?php endif; ?>  
                            </td>
                            <td>
                                <?php if($data->status): ?>
                                <a title="Disable" href="<?php echo e(routeHelper('slider/'. $data->id)); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-thumbs-up"></i>
                                </a> 
                                <?php else: ?>
                                <a title="Active" href="<?php echo e(routeHelper('slider/'. $data->id)); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-thumbs-down"></i>
                                </a> 
                                <?php endif; ?>
                                <a href="<?php echo e(routeHelper('slider/'.$data->id.'/edit')); ?>" class="btn btn-info btn-sm">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="javascript:void(0)" data-id="<?php echo e($data->id); ?>" id="deleteData" class="btn btn-danger btn-sm"">
                                    <i class="nav-icon fas fa-trash-alt"></i>
                                </a>
                                <form id="delete-data-form-<?php echo e($data->id); ?>" action="<?php echo e(routeHelper('slider/'. $data->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                </form>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
      <!-- /.card -->    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <!-- DataTables  & Plugins -->
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script>
        $(function () { 
            $("#example1").DataTable();
        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/admin/e-commerce/slider/index.blade.php ENDPATH**/ ?>