<?php $__env->startSection('title', 'Color Information'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Color Information</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Show Color</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Color Information</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('color/'.$color->id.'/edit')); ?>" class="btn btn-info">
                        <i class="fas fa-edit"></i>
                        Edit
                    </a>
                    <a href="<?php echo e(routeHelper('color')); ?>" class="btn btn-danger">
                        
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <tbody>
                    <tr>
                        <th width="15%">Color Name</th>
                        <td width="85%"><?php echo e($color->name); ?></td>
                    </tr>
                    <tr>
                        <th width="15%">Color Code</th>
                        <td width="85%"><?php echo e($color->code); ?></td>
                    </tr>
                    <tr>
                        <th width="15%">Color Overview</th>
                        <td width="85%">
                            <div style="width:50%;height:50px;background:<?php echo e($color->code); ?>"></div>    
                        </td>
                    </tr>
                    <tr>
                        <th width="15%">Description</th>
                        <td width="85%"><?php echo e($color->description); ?></td>
                    </tr>
                    <tr>
                        <th width="15%">Status</th>
                        <td width="85%">
                            <?php if($color->status): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Disable</span>
                            <?php endif; ?>    
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce2.elitedesign.com.bd/resources/views/admin/e-commerce/color/show.blade.php ENDPATH**/ ?>