<?php $__env->startSection('title', 'Vendor Information'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Vendor Information</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Vendor Product</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card card-solid">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">
                        Vendor Details
                    </h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('vendor/'.$vendor->id.'/edit')); ?>" class="btn btn-info">
                        <i class="fas fa-edit"></i>
                        Edit
                    </a>
                    <a href="<?php echo e(routeHelper('vendor')); ?>" class="btn btn-danger">
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <tbody>
                    <tr>
                        <th>Name</th>
                        <td><?php echo e($vendor->name); ?></td>
                    </tr>
                    <tr>
                        <th>Username</th>
                        <td><?php echo e($vendor->username); ?></td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td><?php echo e($vendor->email); ?></td>
                    </tr>
                    <tr>
                        <th>Phone</th>
                        <td><?php echo e($vendor->phone); ?></td>
                    </tr>
                    
                    <tr>
                        <th>Shop Name</th>
                        <td><?php echo e($vendor->shop_info->name); ?></td>
                    </tr>
                    <tr>
                        <th>Shop Address</th>
                        <td><?php echo e($vendor->shop_info->address); ?></td>
                    </tr>
                    <tr>
                        <th>Shop Url</th>
                        <td><?php echo e($vendor->shop_info->url); ?></td>
                    </tr>
                    <tr>
                        <th>Bank Account</th>
                        <td><?php echo e($vendor->shop_info->bank_account); ?></td>
                    </tr>
                    <tr>
                        <th>Bank Name</th>
                        <td><?php echo e($vendor->shop_info->bank_name); ?></td>
                    </tr>
                    <tr>
                        <th>Holder Name</th>
                        <td><?php echo e($vendor->shop_info->holder_name); ?></td>
                    </tr>
                    <tr>
                        <th>Branch Name</th>
                        <td><?php echo e($vendor->shop_info->branch_name); ?></td>
                    </tr>
                    <tr>
                        <th>Routing</th>
                        <td><?php echo e($vendor->shop_info->routing); ?></td>
                    </tr>
                    <tr>
                        <th>Description</th>
                        <td><?php echo e($vendor->shop_info->description); ?></td>
                    </tr>
                    <tr>
                        <th>Profile</th>
                        <td>
                            <img src="/uploads/shop/profile/<?php echo e($vendor->shop_info->profile); ?>" alt="Profile" width="100px">
                        </td>
                    </tr>
                    <tr>
                        <th>Cover Photo</th>
                        <td>
                            <img src="/uploads/shop/cover/<?php echo e($vendor->shop_info->cover_photo); ?>" alt="Profile" width="100px">
                        </td>
                    </tr>
                    <tr>
                        <th>Nid Photo</th>
                        <td>
                            <img src="/uploads/shop/nid/<?php echo e($vendor->shop_info->nid); ?>" alt="Profile" width="100px">
                        </td>
                    </tr>
                    <tr>
                        <th>Trade Photo</th>
                        <td>
                            <img src="/uploads/shop/trade/<?php echo e($vendor->shop_info->trade); ?>" alt="Profile" width="100px">
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/helpgate/public_html/resources/views/admin/e-commerce/vendor/show.blade.php ENDPATH**/ ?>