<?php $__env->startSection('title'); ?>
    <?php if(isset($staff)): ?>
        Edit Author 
    <?php else: ?> 
        Add Author
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="/assets/plugins/summernote/summernote-bs4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>
                    <?php if(isset($staff)): ?>
                        Edit staff 
                    <?php else: ?> 
                        Add staff
                    <?php endif; ?>
                </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">
                        <?php if(isset($staff)): ?>
                            Edit staff 
                        <?php else: ?> 
                            Add staff
                        <?php endif; ?>
                    </li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <?php if($errors->any()): ?>
        <?php echo implode('', $errors->all('<div class="alert alert-danger">:message</div>')); ?>

    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">
                        <?php if(isset($staff)): ?>
                            Edit Author
                        <?php else: ?> 
                            Add New Author
                        <?php endif; ?>
                    </h3>
                </div>
                <div class="col-sm-6 text-right">
                   
                    <a href="<?php echo e(routeHelper('staff')); ?>" class="btn btn-danger">
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <form action="<?php echo e(isset($staff) ? routeHelper('staff/'. $staff->id) : route('admin.author.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="name">Name:</label>
                        <input type="text" name="name" id="name" placeholder="Write staff name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($staff->name ?? old('name')); ?>" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="profile">Profile</label>
                        <input class="form-control" type="file" name="profile"  required>
                        <?php $__errorArgs = ['profile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                     <div class="form-group col-md-12">
                        <label for="bio">Bio:</label>
                        <textarea name="bio" id="bio" rows="3" placeholder="Write   bio" class="form-control <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" ><?php echo e($product->bio ?? old('bio')); ?></textarea>
                        <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                   
                    
                </div>
                
            </div>
            <div class="card-footer">
                <div class="form-group">
                    <button class="mt-1 btn btn-primary">
                        <?php if(isset($staff)): ?>
                            <i class="fas fa-arrow-circle-up"></i>
                            Update
                        <?php else: ?>
                            <i class="fas fa-plus-circle"></i>
                            Submit
                        <?php endif; ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card -->
    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
 <script src="/assets/plugins/summernote/summernote-bs4.min.js"></script>
 <script>
         $(document).ready(function () {

            $('#bio').summernote()
         })
 </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ofsbazar/public_html/resources/views/admin/e-commerce/author/create.blade.php ENDPATH**/ ?>