<?php $__env->startSection('title', 'Product List'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Product List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Product List</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Product List</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('product/create')); ?>" class="btn btn-success">
                        <i class="fas fa-plus-circle"></i>
                        Add Product
                    </a>
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>RP</th>
                        <th>DP</th>
                        <th>Stock</th>
                        <th>Brand</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td>
                                <img src="<?php echo e(asset('uploads/product/'.$data->image)); ?>" alt="Product Image" width="60px">    
                            </td>
                            <td><?php echo e($data->title); ?></td>
                            <td><?php echo e($data->regular_price); ?></td>
                            <td><?php echo e($data->discount_price); ?></td>
                            <td>
                                <?php if($data->quantity > 0): ?>
                                <span class="badge badge-success">Available</span>
                                <?php else: ?>
                                <span class="badge badge-danger">Unavailable</span>
                                <?php endif; ?>    
                            </td>
                            <td><?php echo e($data->brand->name ?? ''); ?></td>
                            <td>
                                <?php if($data->status): ?>
                                    <span class="badge badge-success">Active</span>
                                    <?php if($data->is_aproved==1): ?>
                                    <span class="badge badge-success">Approved</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Unapproved</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge badge-danger">Pending</span>
                                    <?php if($data->is_aproved==1): ?>
                                    <span class="badge badge-success">Approved</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Unapproved</span>
                                    <?php endif; ?>
                                <?php endif; ?>  
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('vendor.product.order', $data->id)); ?>" title="Order Product" class="btn btn-primary btn-sm">
                                        <i class="fab fa-jedi-order"></i>
                                    </a>
                                    <?php if($data->is_aproved==1): ?>
                                        <?php if($data->status): ?>
                                        <a title="Disable" href="<?php echo e(routeHelper('product/status/'.$data->id)); ?>" class="btn btn-success btn-sm">
                                            <i class="fas fa-thumbs-up"></i>
                                        </a> 
                                        <?php else: ?>
                                        <a title="Active" href="<?php echo e(routeHelper('product/status/'.$data->id)); ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-thumbs-down"></i>
                                        </a> 
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a href="<?php echo e(routeHelper('product/'. $data->id)); ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(routeHelper('product/'.$data->id.'/edit')); ?>" class="btn btn-info btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="javascript:void(0)" data-id="<?php echo e($data->id); ?>" id="deleteData" class="btn btn-danger btn-sm"">
                                        <i class="nav-icon fas fa-trash-alt"></i>
                                    </a>
                                    <form id="delete-data-form-<?php echo e($data->id); ?>" action="<?php echo e(routeHelper('product/'. $data->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </div>
                                

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
                <tfoot>
                    <tr>
                        <th>SL</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>RP</th>
                        <th>DP</th>
                        <th>Stock</th>
                        <th>Brand</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </tfoot>
            </table>
            <?php echo e($products->firstItem()); ?> - <?php echo e($products->lastItem()); ?> of <?php echo e($products->total()); ?> results
                
                
                    <ul class="pagination">
                        
                        <li class="page-item">
                            <a class="page-link" href="<?php echo e($products->url(1)); ?>">First</a>
                        </li>
                
                        
                        <?php
                            $totalPages = ceil($products->total() / $products->perPage());
                            $currentPage = $products->currentPage();
                            $middlePage = floor($totalPages / 2);
                        ?>
                
                        <?php if($totalPages > 3): ?>
                            
                            <?php for($i = max($currentPage - 2, 2); $i < $currentPage; $i++): ?>
                                <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                    <a class="page-link" href="<?php echo e($products->url($i)); ?>"><?php echo e($i); ?></a>
                                </li>
                            <?php endfor; ?>
                
                            
                            <li class="page-item active">
                                <a class="page-link" href="#"><?php echo e($currentPage); ?></a>
                            </li>
                
                            
                            <?php for($i = $currentPage + 1; $i <= min($currentPage + 2, $totalPages - 1); $i++): ?>
                                <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                    <a class="page-link" href="<?php echo e($products->url($i)); ?>"><?php echo e($i); ?></a>
                                </li>
                            <?php endfor; ?>
                
                            
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($products->url($totalPages)); ?>">Last</a>
                            </li>
                        <?php else: ?>
                            
                            <?php for($i = 2; $i < $totalPages; $i++): ?>
                                <li class="page-item <?php echo e($currentPage == $i ? 'active' : ''); ?>">
                                    <a class="page-link" href="<?php echo e($products->url($i)); ?>"><?php echo e($i); ?></a>
                                </li>
                            <?php endfor; ?>
                        <?php endif; ?>

                        <?php if($products->nextPageUrl()): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($products->nextPageUrl()); ?>" aria-label="Next">
                                    <span aria-hidden="true">Next</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
        </div>
        <!-- /.card-body -->
    </div>
      <!-- /.card -->    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <!-- DataTables  & Plugins -->
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="/assets/plugins/jszip/jszip.min.js"></script>
    <script src="/assets/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="/assets/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script>
        $(function () { 
            $("#example1").DataTable({
                "responsive": true,
                // "lengthChange": false,
                "paging": false, // Disable pagination
                "info": false, // Hide information element
                "searching": false, // Hide search input
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce2.elitedesign.com.bd/resources/views/vendor/product/index.blade.php ENDPATH**/ ?>