<?php $__env->startSection('title', 'Order Information'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Order</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Order Information</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <h3 class="card-title">Customer Information</h3>
                        </div>
                        <div class="col-sm-12 col-12 text-right"
                            style="display: flex;
                    flex-direction: row;
                    align-items: center;
                    justify-content: flex-end;
                    grid-column-gap: 8px;">
                            <?php if($order->status != 5): ?>
                                <?php if($order->status != 2): ?>
                                    <?php if($order->status != 3): ?>
                                        <a title="<?php if($order->pay_staus == 1): ?> Unpaid <?php else: ?> Paid <?php endif; ?>"
                                            href="<?php echo e(route('admin.order.pay', ['id' => $order->id])); ?>"
                                            class="btn <?php if($order->pay_staus == 1): ?> btn-danger <?php else: ?> btn-success <?php endif; ?> btn-sm">
                                            <i class="fas fa-money-bill"></i>
                                            <?php if($order->pay_staus == 1): ?>
                                                Unpaid
                                            <?php else: ?>
                                                Paid
                                            <?php endif; ?>
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(setting('STEEDFAST_STATUS') == 1 && $order->status != 9): ?>
                                    <form action="<?php echo e(route('admin.setting.courier.sendsteedfast')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="invoice" value="<?php echo e($order->invoice); ?>">
                                        <input type="hidden" name="recipient_name" value="<?php echo e($order->first_name); ?>">
                                        <input type="hidden" name="recipient_phone" value="<?php echo e($order->phone); ?>">
                                        <input type="hidden" name="recipient_address"
                                            value="<?php echo e($order->address . ', ' . $order->town . ', ' . $order->district . ', ' . $order->post_code); ?>">
                                        <?php if($order->pay_staus == 1): ?>
                                            <input type="hidden" name="cod_amount" value="0.00">
                                        <?php else: ?>
                                            <input type="hidden" name="cod_amount" value="<?php echo e($order->total); ?>">
                                        <?php endif; ?>
                                        <input type="hidden" name="note" value="N/A">
                                        <input class="btn btn-info btn-sm" type="submit" value="Send Courier">
                                    </form>
                                <?php else: ?>
                                    <i class="btn btn-info btn-sm">Courierd Already</i>
                                <?php endif; ?>

                                <a title="Processing" href="<?php echo e(routeHelper('order/status/processing/' . $order->id)); ?>"
                                    onclick="alert('Are you sure change status this order?')"
                                    class="btn btn-primary btn-sm">
                                    <i class="fas fa-running"></i>
                                    Processing
                                </a>

                                <?php if($order->status == 6): ?>
                                    <a title="Accept return request]"
                                        href="<?php echo e(routeHelper('order/status/return_req_accept/' . $order->id)); ?>"
                                        onclick="alert('Return process are start')" class="btn btn-success btn-sm">
                                        Return Accept
                                    </a>
                                <?php elseif($order->status == 7): ?>
                                    <a title="Complete the return process, you got the product from customer as a return completely."
                                        href="<?php echo e(routeHelper('order/status/return_complete/' . $order->id)); ?>"
                                        onclick="alert('Complete the return, you got the product from customer?')"
                                        class="btn btn-success btn-sm">
                                        Return Complete
                                    </a>
                                <?php elseif($order->status != 2 && $order->status != 3 && $order->status != 6 && $order->status != 7 && $order->status != 8): ?>
                                    <a title="Shipping" href="<?php echo e(routeHelper('order/status/shipping/' . $order->id)); ?>"
                                        id="btnShipping" onclick="return confirm('Are you sure Shipping this order?')"
                                        class="btn btn-info btn-sm">
                                        <i class="fas fa-plane"></i> Shipping
                                    </a>

                                    <a title="Delivered" href="<?php echo e(routeHelper('order/status/delivered/' . $order->id)); ?>"
                                        onclick="alert('Are you sure change status this order?')"
                                        class="btn btn-success btn-sm">
                                        <i class="fas fa-thumbs-up"></i>
                                        Delivered
                                    </a>
                                <?php endif; ?>
                                <?php if($order->status != 3 && $order->status != 2): ?>
                                    <a title="Cancel" href="<?php echo e(routeHelper('order/status/cancel/' . $order->id)); ?>"
                                        onclick="alert('Are you sure change status this order?')"
                                        class="btn btn-warning btn-sm">
                                        <i class="fas fa-window-close"></i>
                                        Cancel
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($order->status == 3): ?>
                                <button type="button" class="btn btn-warning btn-sm" data-toggle="modal"
                                    data-target="#refund">
                                    Refund
                                </button>
                            <?php endif; ?>
                            <?php if($order->status == 2): ?>
                                <button type="button" class="btn btn-warning btn-sm" data-toggle="modal"
                                    data-target="#refund2">
                                    Refund
                                </button>
                            <?php endif; ?>
                            <a href="<?php echo e(route('admin.order.delete', ['did' => $order->id])); ?>"
                                class="btn btn-danger btn-sm"><i class="nav-icon fas fa-trash-alt"></i> Delete</a>
                            <a href="<?php echo e(routeHelper('order/print/' . $order->id)); ?>" rel="noopener" target="_blank"
                                class="btn btn-default"><i class="fas fa-print"></i> Print</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-hover">
                        <tbody>
                            <?php if(!empty($order->meet_time)): ?>
                                <tr>
                                    <th>Meet Time</th>
                                    <td><?php echo e($order->meet_time); ?></td>

                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Customer Name</th>
                                <td><?php echo e($order->first_name); ?></td>
                                <th>Order ID</th>
                                <td><?php echo e($order->order_id); ?></td>
                            </tr>
                            <tr>
                                <th>Invoice</th>
                                <td><?php echo e($order->invoice); ?></td>
                                <th>Company Name</th>
                                <td><?php echo e($order->company_name); ?></td>
                            </tr>
                            <tr>
                                <th>Country</th>
                                <td><?php echo e($order->country); ?></td>
                                <th>Address</th>
                                <td><?php echo e($order->address); ?></td>
                            </tr>
                            <tr>
                                <th>Town</th>
                                <td><?php echo e($order->town); ?></td>
                                <th>District</th>
                                <td><?php echo e($order->district); ?></td>
                            </tr>
                            <tr>
                                <th>Post Code</th>
                                <td><?php echo e($order->post_code); ?></td>
                                <th>Phone</th>
                                <td><?php echo e($order->phone); ?></td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td><?php echo e($order->email); ?></td>
                                <th>Shipping Method</th>
                                <td><?php echo e($order->shipping_method); ?></td>
                            </tr>
                            <tr>
                                <th>Payment Method</th>
                                <td colspan="3"><?php echo e($order->payment_method); ?></td>
                            </tr>
                            <?php if($order->payment_method == 'Bkash' || $order->payment_method == 'Nagad' || $order->payment_method == 'Rocket'): ?>
                                <tr>
                                    <th>Mobile Number</th>
                                    <td><?php echo e($order->mobile_number); ?></td>
                                    <th>Transaction ID</th>
                                    <td><?php echo e($order->transaction_id); ?></td>
                                </tr>
                            <?php elseif($order->payment_method == 'Bank'): ?>
                                <tr>
                                    <th>Bank Name</th>
                                    <td><?php echo e($order->bank_name); ?></td>
                                    <th>Account Number</th>
                                    <td><?php echo e($order->account_number); ?></td>
                                </tr>
                                <tr>
                                    <th>Holder Name</th>
                                    <td><?php echo e($order->holder_name); ?></td>
                                    <th>Branch Name</th>
                                    <td><?php echo e($order->branch_name); ?></td>
                                </tr>
                                <tr>
                                    <th>Routing Number</th>
                                    <td colspan="3"><?php echo e($order->routing_number); ?></td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Coupon Code</th>
                                <td><?php echo e($order->coupon_code); ?></td>
                                <th>Subtotal</th>
                                <td><?php echo e($order->subtotal); ?> <strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <th>Shipping Charge</th>
                                <td><?php echo e($order->shipping_charge); ?>

                                    <strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong></td>
                                <th>Discount</th>
                                <td><?php echo e($order->discount); ?> <strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <th>Payment Status</th>
                                <td><?php echo e($order->pay_staus == 1 ? 'Paid' : 'Unpaid'); ?> </td>
                                <th>Payment Date</th>
                                <td><?php echo e($order->pay_date); ?> </td>
                            </tr>
                            <tr>
                                <th>Partial Payment</th>
                                <td>
                                    <?php
                                        $part = App\Models\PartialPayment::where('order_id', $order->id)
                                            ->where('status', 1)
                                            ->sum('amount');
                                        $ds = $order->total;
                                    ?>
                                    <?php echo e($part); ?><strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong>
                                </td>
                                <th>Due</th>
                                <td> <?php echo e($order->total - $part); ?> <strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <th>Total</th>
                                <td><?php echo e($ds); ?> <strong><?php echo e(setting('CURRENCY_CODE_MIN') ?? 'TK'); ?></strong></td>
                                <th>Status</th>
                                <td>

                                    <?php if($order->status == 0): ?>
                                        <span class="badge badge-warning">Pending</span>
                                    <?php elseif($order->status == 1): ?>
                                        <span class="badge badge-primary">Processing</span>
                                    <?php elseif($order->status == 2): ?>
                                        <span class="badge badge-danger">Canceled</span>
                                    <?php elseif($order->status == 5): ?>
                                        <span class="badge badge-danger">Refund</span>
                                    <?php elseif($order->status == 4): ?>
                                        <span class="badge" style="background: #7db1b1;">Shipping</span>
                                    <?php elseif($order->status == 6): ?>
                                        <span class="badge" style="background: #7db1b1;">Return Request By User</span>
                                    <?php elseif($order->status == 7): ?>
                                        <span class="badge" style="background: #7db1b1;">Return process accept by
                                            Owner</span>
                                    <?php elseif($order->status == 8): ?>
                                        <span class="badge" style="background: #7db1b1;">Returned</span>
                                    <?php elseif($order->status == 9): ?>
                                        <span class="badge" style="background: #7db1b1;">Sended to Courier</span>
                                    <?php elseif($order->status == 3): ?>
                                        <span class="badge badge-success">Delivered</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php if($order->status == 5): ?>
                                <tr>
                                    <th>Refund Method</th>
                                    <td><?php echo e($order->refund_method); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal fade" id="refund" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">

                        <div class="modal-body">
                            <form method="post" action="<?php echo e(route('admin.refund')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <input type="hidden" name="order" value="<?php echo e($order->id); ?>">
                                    <input class="form-control" type="text" placeholder="amount" name="amount">
                                </div>
                                <div class="form-group">
                                    <select class="form-control" name="method">
                                        <option value="wallate">Wallate</option>
                                        <option value="Bank">Bank</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Nagad">Nagad</option>
                                        <option value="Rocket">Rocket</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>

                                <button type="submit" class="btn btn-primary">Refund</button>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="refund2" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">

                        <div class="modal-body">
                            <form method="post" action="<?php echo e(route('admin.refund_2')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <input type="hidden" name="order" value="<?php echo e($order->id); ?>">
                                    <input class="form-control" type="text" placeholder="amount" name="amount">
                                </div>
                                <div class="form-group">
                                    <select class="form-control" name="method">
                                        <option value="wallate">Wallate</option>
                                        <option value="Bank">Bank</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Nagad">Nagad</option>
                                        <option value="Rocket">Rocket</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>

                                <button type="submit" class="btn btn-primary">Refund</button>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Order Products</h2>
                </div>
                <div class="card-body">
                    <?php
                        $vendors = DB::table('multi_order')
                            ->where('order_id', $order->id)
                            ->get();
                    ?>
                    <style>
                        .gx {
                            display: flex;
                            background: #6dca6d24;
                            padding: 5px;
                            border-radius: 5px;
                            margin-bottom: 10px;
                        }

                        .gx div {
                            flex: 1;
                        }
                    </style>
                    <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php ($us = App\Models\User::find($vendor->vendor_id)); ?>
                        <div class="gx" style="">
                            <div>
                                Seller:<?php echo e($us->name); ?>

                            </div>
                            <div>
                                Total:<?php echo e($vendor->total); ?>

                            </div>
                            <div>
                                Payment:<?php echo e($vendor->partial_pay); ?>

                            </div>
                            <div>
                                Discount:<?php echo e($vendor->discount); ?>

                            </div>
                            <div>
                                Status:
                                <?php if($vendor->status == 0): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif($vendor->status == 1): ?>
                                    <span class="badge badge-primary">Processing</span>
                                <?php elseif($vendor->status == 2): ?>
                                    <span class="badge badge-danger">Canceled</span>
                                <?php elseif($vendor->status == 4): ?>
                                    <span class="badge" style="background: #7db1b1;">Shipping</span>
                                <?php elseif($vendor->status == 5): ?>
                                    <span class="badge badge-danger">Refund</span>
                                <?php elseif($order->status == 6): ?>
                                    <span class="badge" style="background: #7db1b1;">Return Request By User</span>
                                <?php elseif($order->status == 7): ?>
                                    <span class="badge" style="background: #7db1b1;">Return process accept by
                                        Owner</span>
                                <?php elseif($order->status == 8): ?>
                                    <span class="badge" style="background: #7db1b1;">Returned</span>
                                <?php elseif($order->status == 3): ?>
                                    <span class="badge badge-success">Delivered</span>
                                <?php endif; ?>
                            </div>

                        </div>
                        <div>
                            <a
                                href="<?php echo e(route('admin.order.subStatus', ['id' => $order->id, 'status' => 1, 'vendor' => $vendor->vendor_id])); ?>">Processing</a>
                            <a
                                href="<?php echo e(route('admin.order.subStatus', ['id' => $order->id, 'status' => 4, 'vendor' => $vendor->vendor_id])); ?>">Shipping</a>
                            <a
                                href="<?php echo e(route('admin.order.subStatus', ['id' => $order->id, 'status' => 2, 'vendor' => $vendor->vendor_id])); ?>">Canceled</a>
                            <a
                                href="<?php echo e(route('admin.order.subStatus', ['id' => $order->id, 'status' => 3, 'vendor' => $vendor->vendor_id])); ?>">Delivered</a>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Product</th>
                                        <th>Title</th>
                                        <th>Size</th>
                                        <th>Color</th>
                                        <th>Qty</th>
                                        <th>Price</th>
                                        <th>Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $order->orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($item->product->user_id) && $item->product->user_id == $vendor->vendor_id): ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td>
                                                    <img src="<?php echo e(asset('uploads/product/' . $item->product->image)); ?>"
                                                        alt="Product Image" width="80px" height="80px">
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.product.show', $item->product->id)); ?>"
                                                        target="_blank"><?php echo e($item->title); ?></a>
                                                </td>
                                                <td><?php
                                                $data = json_decode($item->size);
                                                if ($data != null && $data != '""' && $data != '[]' && $data != '"\"\""') {
                                                    foreach ($data as $key => $attr) {
                                                        $value = DB::table('attribute_values')->where('id', $attr)->first();
                                                        $name = DB::table('attributes')->where('slug', $key)->first();
                                                        if ($name) {
                                                            echo $vl = $name->name . ':' . $value->name . ', ';
                                                        }
                                                    }
                                                }
                                                ?></td>
                                                <td> <?php
                                                if ($item->color != 'blank') {
                                                    echo $item->color;
                                                }
                                                ?></td>
                                                <td><?php echo e($item->qty); ?></td>
                                                <td><?php echo e($item->price); ?></td>
                                                <td><?php echo e($item->total_price); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

            </div>

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/admin/e-commerce/order/show.blade.php ENDPATH**/ ?>