<?php

/*
 * (c) Our Code World <dev@ourcodeworld.com>
 *
 * This library is a PHP port (written by Our Code World) of the JavaScript library NTC JS.
 *
    +-----------------------------------------------------------------+
    |     Created by Chirag Mehta - http://chir.ag/projects/ntc       |
    |-----------------------------------------------------------------|
    |               ntc js (Name that Color JavaScript)               |
    +-----------------------------------------------------------------+

    All the functions, code, lists etc. have been written specifically
    for the Name that Color JavaScript by Chirag Mehta unless otherwise
    specified.

    http://chir.ag/projects/ntc/
 * 
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace ourcodeworld\NameThatColor;

class ColorInterpreter {

    public function __construct(){
        $color = null;
        $rgb = null;
        $hsl = null;

        for($i = 0; $i < count($this->names); $i++)
        {
            $color = "#" . $this->names[$i][0];
            $rgb = $this->rgb($color);
            $hsl = $this->hsl($color);

            array_push(
                $this->names[$i], 
                $rgb[0], 
                $rgb[1], 
                $rgb[2], 
                $hsl[0], 
                $hsl[1], 
                $hsl[2]
            );
        }   
    }

    public function name($color){
        $color = strtoupper($color);

        if(strlen($color) < 3 || strlen($color) > 7){
            return array(
                "hex" => "#000000",
                "name" => "Invalid Color: " . $color,
                "exact" => false
            );
        }
        
        // If given the format without #
        if(strlen($color) % 3 == 0){
            $color = "#" . $color;
        }
        
        // If given #fea, duplicate every char e.g #ffeeaa
        if(strlen($color) == 4){
            $color = "#" . $color.substr(1, 1) . $color.substr(1, 1) . $color.substr(2, 1) . $color.substr(2, 1) . $color.substr(3, 1) . $color.substr(3, 1);
        }
          
        $rgb = $this->rgb($color);

        $r = $rgb[0];
        $g = $rgb[1];
        $b = $rgb[2];

        $hsl = $this->hsl($color);

        $h = $hsl[0];
        $s = $hsl[1];
        $l = $hsl[2];

        $ndf1 = 0; 
        $ndf2 = 0; 
        $ndf = 0;

        $cl = -1;
        $df = -1;
    
        for($i = 0; $i < count($this->names); $i++)
        {
            if($color == "#" . $this->names[$i][0]){
                return array(
                    "hex" => "#" . $this->names[$i][0], 
                    "name" => $this->names[$i][1], 
                    "exact" => true
                );
            }

            $ndf1 = pow($r - $this->names[$i][2], 2) + pow($g - $this->names[$i][3], 2) + pow($b - $this->names[$i][4], 2);
            $ndf2 = pow($h - $this->names[$i][5], 2) + pow($s - $this->names[$i][6], 2) + pow($l - $this->names[$i][7], 2);
            $ndf = $ndf1 + $ndf2 * 2;

            if($df < 0 || $df > $ndf)
            {
                $df = $ndf;
                $cl = $i;
            }
        }
        
        if($cl < 0){
            return array(
                "hex" => "#000000",
                "name" => "Invalid Color: " . $color,
                "exact" => false
            );
        }else{
            return array(
                "hex" => "#" . $this->names[$cl][0],
                "name" => $this->names[$cl][1],
                "exact" => false
            );
        }
    }

    // adopted from: Farbtastic 1.2
    // http://acko.net/dev/farbtastic
    public function hsl($color) {
        $rgb = array(
            intval(hexdec(substr($color, 1, 2))) / 255, 
            intval(hexdec(substr($color, 3, 2))) / 255, 
            intval(hexdec(substr($color, 5, 7))) / 255
        );

        $min = null;
        $max = null;
        $delta = null;
        $h = null;
        $s = null;
        $l = null;

        $r = $rgb[0];
        $g = $rgb[1];
        $b = $rgb[2];

        $min = min($r, min($g, $b));
        $max = max($r, max($g, $b));
        $delta = $max - $min;
        $l = ($min + $max) / 2;

        $s = 0;
        if($l > 0 && $l < 1)
        $s = $delta / ($l < 0.5 ? (2 * $l) : (2 - 2 * $l));

        $h = 0;
        if($delta > 0)
        {
            if ($max == $r && $max != $g) $h += ($g - $b) / $delta;
            if ($max == $g && $max != $b) $h += (2 + ($b - $r) / $delta);
            if ($max == $b && $max != $r) $h += (4 + ($r - $g) / $delta);
            $h /= 6;
        }

        return array(
            intval($h * 255), 
            intval($s * 255),
            intval($l * 255)
        );
    }

    // adopted from: Farbtastic 1.2
    // http://acko.net/dev/farbtastic
    public function rgb($color) {
        return array(
            hexdec(substr($color, 1, 2)), 
            hexdec(substr($color, 3, 2)),  
            hexdec(substr($color, 5, 7))
        );
    }

    public $names = array(
        array("000000", "Black"),
        array("000080", "Navy Blue"),
        array("0000C8", "Dark Blue"),
        array("0000FF", "Blue"),
        array("000741", "Stratos"),
        array("001B1C", "Swamp"),
        array("002387", "Resolution Blue"),
        array("002900", "Deep Fir"),
        array("002E20", "Burnham"),
        array("002FA7", "International Klein Blue"),
        array("003153", "Prussian Blue"),
        array("003366", "Midnight Blue"),
        array("003399", "Smalt"),
        array("003532", "Deep Teal"),
        array("003E40", "Cyprus"),
        array("004620", "Kaitoke Green"),
        array("0047AB", "Cobalt"),
        array("004816", "Crusoe"),
        array("004950", "Sherpa Blue"),
        array("0056A7", "Endeavour"),
        array("00581A", "Camarone"),
        array("0066CC", "Science Blue"),
        array("0066FF", "Blue Ribbon"),
        array("00755E", "Tropical Rain Forest"),
        array("0076A3", "Allports"),
        array("007BA7", "Deep Cerulean"),
        array("007EC7", "Lochmara"),
        array("007FFF", "Azure Radiance"),
        array("008080", "Teal"),
        array("0095B6", "Bondi Blue"),
        array("009DC4", "Pacific Blue"),
        array("00A693", "Persian Green"),
        array("00A86B", "Jade"),
        array("00CC99", "Caribbean Green"),
        array("00CCCC", "Robin's Egg Blue"),
        array("00FF00", "Green"),
        array("00FF7F", "Spring Green"),
        array("00FFFF", "Cyan / Aqua"),
        array("010D1A", "Blue Charcoal"),
        array("011635", "Midnight"),
        array("011D13", "Holly"),
        array("012731", "Daintree"),
        array("01361C", "Cardin Green"),
        array("01371A", "County Green"),
        array("013E62", "Astronaut Blue"),
        array("013F6A", "Regal Blue"),
        array("014B43", "Aqua Deep"),
        array("015E85", "Orient"),
        array("016162", "Blue Stone"),
        array("016D39", "Fun Green"),
        array("01796F", "Pine Green"),
        array("017987", "Blue Lagoon"),
        array("01826B", "Deep Sea"),
        array("01A368", "Green Haze"),
        array("022D15", "English Holly"),
        array("02402C", "Sherwood Green"),
        array("02478E", "Congress Blue"),
        array("024E46", "Evening Sea"),
        array("026395", "Bahama Blue"),
        array("02866F", "Observatory"),
        array("02A4D3", "Cerulean"),
        array("03163C", "Tangaroa"),
        array("032B52", "Green Vogue"),
        array("036A6E", "Mosque"),
        array("041004", "Midnight Moss"),
        array("041322", "Black Pearl"),
        array("042E4C", "Blue Whale"),
        array("044022", "Zuccini"),
        array("044259", "Teal Blue"),
        array("051040", "Deep Cove"),
        array("051657", "Gulf Blue"),
        array("055989", "Venice Blue"),
        array("056F57", "Watercourse"),
        array("062A78", "Catalina Blue"),
        array("063537", "Tiber"),
        array("069B81", "Gossamer"),
        array("06A189", "Niagara"),
        array("073A50", "Tarawera"),
        array("080110", "Jaguar"),
        array("081910", "Black Bean"),
        array("082567", "Deep Sapphire"),
        array("088370", "Elf Green"),
        array("08E8DE", "Bright Turquoise"),
        array("092256", "Downriver"),
        array("09230F", "Palm Green"),
        array("09255D", "Madison"),
        array("093624", "Bottle Green"),
        array("095859", "Deep Sea Green"),
        array("097F4B", "Salem"),
        array("0A001C", "Black Russian"),
        array("0A480D", "Dark Fern"),
        array("0A6906", "Japanese Laurel"),
        array("0A6F75", "Atoll"),
        array("0B0B0B", "Cod Gray"),
        array("0B0F08", "Marshland"),
        array("0B1107", "Gordons Green"),
        array("0B1304", "Black Forest"),
        array("0B6207", "San Felix"),
        array("0BDA51", "Malachite"),
        array("0C0B1D", "Ebony"),
        array("0C0D0F", "Woodsmoke"),
        array("0C1911", "Racing Green"),
        array("0C7A79", "Surfie Green"),
        array("0C8990", "Blue Chill"),
        array("0D0332", "Black Rock"),
        array("0D1117", "Bunker"),
        array("0D1C19", "Aztec"),
        array("0D2E1C", "Bush"),
        array("0E0E18", "Cinder"),
        array("0E2A30", "Firefly"),
        array("0F2D9E", "Torea Bay"),
        array("10121D", "Vulcan"),
        array("101405", "Green Waterloo"),
        array("105852", "Eden"),
        array("110C6C", "Arapawa"),
        array("120A8F", "Ultramarine"),
        array("123447", "Elephant"),
        array("126B40", "Jewel"),
        array("130000", "Diesel"),
        array("130A06", "Asphalt"),
        array("13264D", "Blue Zodiac"),
        array("134F19", "Parsley"),
        array("140600", "Nero"),
        array("1450AA", "Tory Blue"),
        array("151F4C", "Bunting"),
        array("1560BD", "Denim"),
        array("15736B", "Genoa"),
        array("161928", "Mirage"),
        array("161D10", "Hunter Green"),
        array("162A40", "Big Stone"),
        array("163222", "Celtic"),
        array("16322C", "Timber Green"),
        array("163531", "Gable Green"),
        array("171F04", "Pine Tree"),
        array("175579", "Chathams Blue"),
        array("182D09", "Deep Forest Green"),
        array("18587A", "Blumine"),
        array("19330E", "Palm Leaf"),
        array("193751", "Nile Blue"),
        array("1959A8", "Fun Blue"),
        array("1A1A68", "Lucky Point"),
        array("1AB385", "Mountain Meadow"),
        array("1B0245", "Tolopea"),
        array("1B1035", "Haiti"),
        array("1B127B", "Deep Koamaru"),
        array("1B1404", "Acadia"),
        array("1B2F11", "Seaweed"),
        array("1B3162", "Biscay"),
        array("1B659D", "Matisse"),
        array("1C1208", "Crowshead"),
        array("1C1E13", "Rangoon Green"),
        array("1C39BB", "Persian Blue"),
        array("1C402E", "Everglade"),
        array("1C7C7D", "Elm"),
        array("1D6142", "Green Pea"),
        array("1E0F04", "Creole"),
        array("1E1609", "Karaka"),
        array("1E1708", "El Paso"),
        array("1E385B", "Cello"),
        array("1E433C", "Te Papa Green"),
        array("1E90FF", "Dodger Blue"),
        array("1E9AB0", "Eastern Blue"),
        array("1F120F", "Night Rider"),
        array("1FC2C2", "Java"),
        array("20208D", "Jacksons Purple"),
        array("202E54", "Cloud Burst"),
        array("204852", "Blue Dianne"),
        array("211A0E", "Eternity"),
        array("220878", "Deep Blue"),
        array("228B22", "Forest Green"),
        array("233418", "Mallard"),
        array("240A40", "Violet"),
        array("240C02", "Kilamanjaro"),
        array("242A1D", "Log Cabin"),
        array("242E16", "Black Olive"),
        array("24500F", "Green House"),
        array("251607", "Graphite"),
        array("251706", "Cannon Black"),
        array("251F4F", "Port Gore"),
        array("25272C", "Shark"),
        array("25311C", "Green Kelp"),
        array("2596D1", "Curious Blue"),
        array("260368", "Paua"),
        array("26056A", "Paris M"),
        array("261105", "Wood Bark"),
        array("261414", "Gondola"),
        array("262335", "Steel Gray"),
        array("26283B", "Ebony Clay"),
        array("273A81", "Bay of Many"),
        array("27504B", "Plantation"),
        array("278A5B", "Eucalyptus"),
        array("281E15", "Oil"),
        array("283A77", "Astronaut"),
        array("286ACD", "Mariner"),
        array("290C5E", "Violent Violet"),
        array("292130", "Bastille"),
        array("292319", "Zeus"),
        array("292937", "Charade"),
        array("297B9A", "Jelly Bean"),
        array("29AB87", "Jungle Green"),
        array("2A0359", "Cherry Pie"),
        array("2A140E", "Coffee Bean"),
        array("2A2630", "Baltic Sea"),
        array("2A380B", "Turtle Green"),
        array("2A52BE", "Cerulean Blue"),
        array("2B0202", "Sepia Black"),
        array("2B194F", "Valhalla"),
        array("2B3228", "Heavy Metal"),
        array("2C0E8C", "Blue Gem"),
        array("2C1632", "Revolver"),
        array("2C2133", "Bleached Cedar"),
        array("2C8C84", "Lochinvar"),
        array("2D2510", "Mikado"),
        array("2D383A", "Outer Space"),
        array("2D569B", "St Tropaz"),
        array("2E0329", "Jacaranda"),
        array("2E1905", "Jacko Bean"),
        array("2E3222", "Rangitoto"),
        array("2E3F62", "Rhino"),
        array("2E8B57", "Sea Green"),
        array("2EBFD4", "Scooter"),
        array("2F270E", "Onion"),
        array("2F3CB3", "Governor Bay"),
        array("2F519E", "Sapphire"),
        array("2F5A57", "Spectra"),
        array("2F6168", "Casal"),
        array("300529", "Melanzane"),
        array("301F1E", "Cocoa Brown"),
        array("302A0F", "Woodrush"),
        array("304B6A", "San Juan"),
        array("30D5C8", "Turquoise"),
        array("311C17", "Eclipse"),
        array("314459", "Pickled Bluewood"),
        array("315BA1", "Azure"),
        array("31728D", "Calypso"),
        array("317D82", "Paradiso"),
        array("32127A", "Persian Indigo"),
        array("32293A", "Blackcurrant"),
        array("323232", "Mine Shaft"),
        array("325D52", "Stromboli"),
        array("327C14", "Bilbao"),
        array("327DA0", "Astral"),
        array("33036B", "Christalle"),
        array("33292F", "Thunder"),
        array("33CC99", "Shamrock"),
        array("341515", "Tamarind"),
        array("350036", "Mardi Gras"),
        array("350E42", "Valentino"),
        array("350E57", "Jagger"),
        array("353542", "Tuna"),
        array("354E8C", "Chambray"),
        array("363050", "Martinique"),
        array("363534", "Tuatara"),
        array("363C0D", "Waiouru"),
        array("36747D", "Ming"),
        array("368716", "La Palma"),
        array("370202", "Chocolate"),
        array("371D09", "Clinker"),
        array("37290E", "Brown Tumbleweed"),
        array("373021", "Birch"),
        array("377475", "Oracle"),
        array("380474", "Blue Diamond"),
        array("381A51", "Grape"),
        array("383533", "Dune"),
        array("384555", "Oxford Blue"),
        array("384910", "Clover"),
        array("394851", "Limed Spruce"),
        array("396413", "Dell"),
        array("3A0020", "Toledo"),
        array("3A2010", "Sambuca"),
        array("3A2A6A", "Jacarta"),
        array("3A686C", "William"),
        array("3A6A47", "Killarney"),
        array("3AB09E", "Keppel"),
        array("3B000B", "Temptress"),
        array("3B0910", "Aubergine"),
        array("3B1F1F", "Jon"),
        array("3B2820", "Treehouse"),
        array("3B7A57", "Amazon"),
        array("3B91B4", "Boston Blue"),
        array("3C0878", "Windsor"),
        array("3C1206", "Rebel"),
        array("3C1F76", "Meteorite"),
        array("3C2005", "Dark Ebony"),
        array("3C3910", "Camouflage"),
        array("3C4151", "Bright Gray"),
        array("3C4443", "Cape Cod"),
        array("3C493A", "Lunar Green"),
        array("3D0C02", "Bean  "),
        array("3D2B1F", "Bistre"),
        array("3D7D52", "Goblin"),
        array("3E0480", "Kingfisher Daisy"),
        array("3E1C14", "Cedar"),
        array("3E2B23", "English Walnut"),
        array("3E2C1C", "Black Marlin"),
        array("3E3A44", "Ship Gray"),
        array("3EABBF", "Pelorous"),
        array("3F2109", "Bronze"),
        array("3F2500", "Cola"),
        array("3F3002", "Madras"),
        array("3F307F", "Minsk"),
        array("3F4C3A", "Cabbage Pont"),
        array("3F583B", "Tom Thumb"),
        array("3F5D53", "Mineral Green"),
        array("3FC1AA", "Puerto Rico"),
        array("3FFF00", "Harlequin"),
        array("401801", "Brown Pod"),
        array("40291D", "Cork"),
        array("403B38", "Masala"),
        array("403D19", "Thatch Green"),
        array("405169", "Fiord"),
        array("40826D", "Viridian"),
        array("40A860", "Chateau Green"),
        array("410056", "Ripe Plum"),
        array("411F10", "Paco"),
        array("412010", "Deep Oak"),
        array("413C37", "Merlin"),
        array("414257", "Gun Powder"),
        array("414C7D", "East Bay"),
        array("4169E1", "Royal Blue"),
        array("41AA78", "Ocean Green"),
        array("420303", "Burnt Maroon"),
        array("423921", "Lisbon Brown"),
        array("427977", "Faded Jade"),
        array("431560", "Scarlet Gum"),
        array("433120", "Iroko"),
        array("433E37", "Armadillo"),
        array("434C59", "River Bed"),
        array("436A0D", "Green Leaf"),
        array("44012D", "Barossa"),
        array("441D00", "Morocco Brown"),
        array("444954", "Mako"),
        array("454936", "Kelp"),
        array("456CAC", "San Marino"),
        array("45B1E8", "Picton Blue"),
        array("460B41", "Loulou"),
        array("462425", "Crater Brown"),
        array("465945", "Gray Asparagus"),
        array("4682B4", "Steel Blue"),
        array("480404", "Rustic Red"),
        array("480607", "Bulgarian Rose"),
        array("480656", "Clairvoyant"),
        array("481C1C", "Cocoa Bean"),
        array("483131", "Woody Brown"),
        array("483C32", "Taupe"),
        array("49170C", "Van Cleef"),
        array("492615", "Brown Derby"),
        array("49371B", "Metallic Bronze"),
        array("495400", "Verdun Green"),
        array("496679", "Blue Bayoux"),
        array("497183", "Bismark"),
        array("4A2A04", "Bracken"),
        array("4A3004", "Deep Bronze"),
        array("4A3C30", "Mondo"),
        array("4A4244", "Tundora"),
        array("4A444B", "Gravel"),
        array("4A4E5A", "Trout"),
        array("4B0082", "Pigment Indigo"),
        array("4B5D52", "Nandor"),
        array("4C3024", "Saddle"),
        array("4C4F56", "Abbey"),
        array("4D0135", "Blackberry"),
        array("4D0A18", "Cab Sav"),
        array("4D1E01", "Indian Tan"),
        array("4D282D", "Cowboy"),
        array("4D282E", "Livid Brown"),
        array("4D3833", "Rock"),
        array("4D3D14", "Punga"),
        array("4D400F", "Bronzetone"),
        array("4D5328", "Woodland"),
        array("4E0606", "Mahogany"),
        array("4E2A5A", "Bossanova"),
        array("4E3B41", "Matterhorn"),
        array("4E420C", "Bronze Olive"),
        array("4E4562", "Mulled Wine"),
        array("4E6649", "Axolotl"),
        array("4E7F9E", "Wedgewood"),
        array("4EABD1", "Shakespeare"),
        array("4F1C70", "Honey Flower"),
        array("4F2398", "Daisy Bush"),
        array("4F69C6", "Indigo"),
        array("4F7942", "Fern Green"),
        array("4F9D5D", "Fruit Salad"),
        array("4FA83D", "Apple"),
        array("504351", "Mortar"),
        array("507096", "Kashmir Blue"),
        array("507672", "Cutty Sark"),
        array("50C878", "Emerald"),
        array("514649", "Emperor"),
        array("516E3D", "Chalet Green"),
        array("517C66", "Como"),
        array("51808F", "Smalt Blue"),
        array("52001F", "Castro"),
        array("520C17", "Maroon Oak"),
        array("523C94", "Gigas"),
        array("533455", "Voodoo"),
        array("534491", "Victoria"),
        array("53824B", "Hippie Green"),
        array("541012", "Heath"),
        array("544333", "Judge Gray"),
        array("54534D", "Fuscous Gray"),
        array("549019", "Vida Loca"),
        array("55280C", "Cioccolato"),
        array("555B10", "Saratoga"),
        array("556D56", "Finlandia"),
        array("5590D9", "Havelock Blue"),
        array("56B4BE", "Fountain Blue"),
        array("578363", "Spring Leaves"),
        array("583401", "Saddle Brown"),
        array("585562", "Scarpa Flow"),
        array("587156", "Cactus"),
        array("589AAF", "Hippie Blue"),
        array("591D35", "Wine Berry"),
        array("592804", "Brown Bramble"),
        array("593737", "Congo Brown"),
        array("594433", "Millbrook"),
        array("5A6E9C", "Waikawa Gray"),
        array("5A87A0", "Horizon"),
        array("5B3013", "Jambalaya"),
        array("5C0120", "Bordeaux"),
        array("5C0536", "Mulberry Wood"),
        array("5C2E01", "Carnaby Tan"),
        array("5C5D75", "Comet"),
        array("5D1E0F", "Redwood"),
        array("5D4C51", "Don Juan"),
        array("5D5C58", "Chicago"),
        array("5D5E37", "Verdigris"),
        array("5D7747", "Dingley"),
        array("5DA19F", "Breaker Bay"),
        array("5E483E", "Kabul"),
        array("5E5D3B", "Hemlock"),
        array("5F3D26", "Irish Coffee"),
        array("5F5F6E", "Mid Gray"),
        array("5F6672", "Shuttle Gray"),
        array("5FA777", "Aqua Forest"),
        array("5FB3AC", "Tradewind"),
        array("604913", "Horses Neck"),
        array("605B73", "Smoky"),
        array("606E68", "Corduroy"),
        array("6093D1", "Danube"),
        array("612718", "Espresso"),
        array("614051", "Eggplant"),
        array("615D30", "Costa Del Sol"),
        array("61845F", "Glade Green"),
        array("622F30", "Buccaneer"),
        array("623F2D", "Quincy"),
        array("624E9A", "Butterfly Bush"),
        array("625119", "West Coast"),
        array("626649", "Finch"),
        array("639A8F", "Patina"),
        array("63B76C", "Fern"),
        array("6456B7", "Blue Violet"),
        array("646077", "Dolphin"),
        array("646463", "Storm Dust"),
        array("646A54", "Siam"),
        array("646E75", "Nevada"),
        array("6495ED", "Cornflower Blue"),
        array("64CCDB", "Viking"),
        array("65000B", "Rosewood"),
        array("651A14", "Cherrywood"),
        array("652DC1", "Purple Heart"),
        array("657220", "Fern Frond"),
        array("65745D", "Willow Grove"),
        array("65869F", "Hoki"),
        array("660045", "Pompadour"),
        array("660099", "Purple"),
        array("66023C", "Tyrian Purple"),
        array("661010", "Dark Tan"),
        array("66B58F", "Silver Tree"),
        array("66FF00", "Bright Green"),
        array("66FF66", "Screamin' Green"),
        array("67032D", "Black Rose"),
        array("675FA6", "Scampi"),
        array("676662", "Ironside Gray"),
        array("678975", "Viridian Green"),
        array("67A712", "Christi"),
        array("683600", "Nutmeg Wood Finish"),
        array("685558", "Zambezi"),
        array("685E6E", "Salt Box"),
        array("692545", "Tawny Port"),
        array("692D54", "Finn"),
        array("695F62", "Scorpion"),
        array("697E9A", "Lynch"),
        array("6A442E", "Spice"),
        array("6A5D1B", "Himalaya"),
        array("6A6051", "Soya Bean"),
        array("6B2A14", "Hairy Heath"),
        array("6B3FA0", "Royal Purple"),
        array("6B4E31", "Shingle Fawn"),
        array("6B5755", "Dorado"),
        array("6B8BA2", "Bermuda Gray"),
        array("6B8E23", "Olive Drab"),
        array("6C3082", "Eminence"),
        array("6CDAE7", "Turquoise Blue"),
        array("6D0101", "Lonestar"),
        array("6D5E54", "Pine Cone"),
        array("6D6C6C", "Dove Gray"),
        array("6D9292", "Juniper"),
        array("6D92A1", "Gothic"),
        array("6E0902", "Red Oxide"),
        array("6E1D14", "Moccaccino"),
        array("6E4826", "Pickled Bean"),
        array("6E4B26", "Dallas"),
        array("6E6D57", "Kokoda"),
        array("6E7783", "Pale Sky"),
        array("6F440C", "Cafe Royale"),
        array("6F6A61", "Flint"),
        array("6F8E63", "Highland"),
        array("6F9D02", "Limeade"),
        array("6FD0C5", "Downy"),
        array("701C1C", "Persian Plum"),
        array("704214", "Sepia"),
        array("704A07", "Antique Bronze"),
        array("704F50", "Ferra"),
        array("706555", "Coffee"),
        array("708090", "Slate Gray"),
        array("711A00", "Cedar Wood Finish"),
        array("71291D", "Metallic Copper"),
        array("714693", "Affair"),
        array("714AB2", "Studio"),
        array("715D47", "Tobacco Brown"),
        array("716338", "Yellow Metal"),
        array("716B56", "Peat"),
        array("716E10", "Olivetone"),
        array("717486", "Storm Gray"),
        array("718080", "Sirocco"),
        array("71D9E2", "Aquamarine Blue"),
        array("72010F", "Venetian Red"),
        array("724A2F", "Old Copper"),
        array("726D4E", "Go Ben"),
        array("727B89", "Raven"),
        array("731E8F", "Seance"),
        array("734A12", "Raw Umber"),
        array("736C9F", "Kimberly"),
        array("736D58", "Crocodile"),
        array("737829", "Crete"),
        array("738678", "Xanadu"),
        array("74640D", "Spicy Mustard"),
        array("747D63", "Limed Ash"),
        array("747D83", "Rolling Stone"),
        array("748881", "Blue Smoke"),
        array("749378", "Laurel"),
        array("74C365", "Mantis"),
        array("755A57", "Russett"),
        array("7563A8", "Deluge"),
        array("76395D", "Cosmic"),
        array("7666C6", "Blue Marguerite"),
        array("76BD17", "Lima"),
        array("76D7EA", "Sky Blue"),
        array("770F05", "Dark Burgundy"),
        array("771F1F", "Crown of Thorns"),
        array("773F1A", "Walnut"),
        array("776F61", "Pablo"),
        array("778120", "Pacifika"),
        array("779E86", "Oxley"),
        array("77DD77", "Pastel Green"),
        array("780109", "Japanese Maple"),
        array("782D19", "Mocha"),
        array("782F16", "Peanut"),
        array("78866B", "Camouflage Green"),
        array("788A25", "Wasabi"),
        array("788BBA", "Ship Cove"),
        array("78A39C", "Sea Nymph"),
        array("795D4C", "Roman Coffee"),
        array("796878", "Old Lavender"),
        array("796989", "Rum"),
        array("796A78", "Fedora"),
        array("796D62", "Sandstone"),
        array("79DEEC", "Spray"),
        array("7A013A", "Siren"),
        array("7A58C1", "Fuchsia Blue"),
        array("7A7A7A", "Boulder"),
        array("7A89B8", "Wild Blue Yonder"),
        array("7AC488", "De York"),
        array("7B3801", "Red Beech"),
        array("7B3F00", "Cinnamon"),
        array("7B6608", "Yukon Gold"),
        array("7B7874", "Tapa"),
        array("7B7C94", "Waterloo "),
        array("7B8265", "Flax Smoke"),
        array("7B9F80", "Amulet"),
        array("7BA05B", "Asparagus"),
        array("7C1C05", "Kenyan Copper"),
        array("7C7631", "Pesto"),
        array("7C778A", "Topaz"),
        array("7C7B7A", "Concord"),
        array("7C7B82", "Jumbo"),
        array("7C881A", "Trendy Green"),
        array("7CA1A6", "Gumbo"),
        array("7CB0A1", "Acapulco"),
        array("7CB7BB", "Neptune"),
        array("7D2C14", "Pueblo"),
        array("7DA98D", "Bay Leaf"),
        array("7DC8F7", "Malibu"),
        array("7DD8C6", "Bermuda"),
        array("7E3A15", "Copper Canyon"),
        array("7F1734", "Claret"),
        array("7F3A02", "Peru Tan"),
        array("7F626D", "Falcon"),
        array("7F7589", "Mobster"),
        array("7F76D3", "Moody Blue"),
        array("7FFF00", "Chartreuse"),
        array("7FFFD4", "Aquamarine"),
        array("800000", "Maroon"),
        array("800B47", "Rose Bud Cherry"),
        array("801818", "Falu Red"),
        array("80341F", "Red Robin"),
        array("803790", "Vivid Violet"),
        array("80461B", "Russet"),
        array("807E79", "Friar Gray"),
        array("808000", "Olive"),
        array("808080", "Gray"),
        array("80B3AE", "Gulf Stream"),
        array("80B3C4", "Glacier"),
        array("80CCEA", "Seagull"),
        array("81422C", "Nutmeg"),
        array("816E71", "Spicy Pink"),
        array("817377", "Empress"),
        array("819885", "Spanish Green"),
        array("826F65", "Sand Dune"),
        array("828685", "Gunsmoke"),
        array("828F72", "Battleship Gray"),
        array("831923", "Merlot"),
        array("837050", "Shadow"),
        array("83AA5D", "Chelsea Cucumber"),
        array("83D0C6", "Monte Carlo"),
        array("843179", "Plum"),
        array("84A0A0", "Granny Smith"),
        array("8581D9", "Chetwode Blue"),
        array("858470", "Bandicoot"),
        array("859FAF", "Bali Hai"),
        array("85C4CC", "Half Baked"),
        array("860111", "Red Devil"),
        array("863C3C", "Lotus"),
        array("86483C", "Ironstone"),
        array("864D1E", "Bull Shot"),
        array("86560A", "Rusty Nail"),
        array("868974", "Bitter"),
        array("86949F", "Regent Gray"),
        array("871550", "Disco"),
        array("87756E", "Americano"),
        array("877C7B", "Hurricane"),
        array("878D91", "Oslo Gray"),
        array("87AB39", "Sushi"),
        array("885342", "Spicy Mix"),
        array("886221", "Kumera"),
        array("888387", "Suva Gray"),
        array("888D65", "Avocado"),
        array("893456", "Camelot"),
        array("893843", "Solid Pink"),
        array("894367", "Cannon Pink"),
        array("897D6D", "Makara"),
        array("8A3324", "Burnt Umber"),
        array("8A73D6", "True V"),
        array("8A8360", "Clay Creek"),
        array("8A8389", "Monsoon"),
        array("8A8F8A", "Stack"),
        array("8AB9F1", "Jordy Blue"),
        array("8B00FF", "Electric Violet"),
        array("8B0723", "Monarch"),
        array("8B6B0B", "Corn Harvest"),
        array("8B8470", "Olive Haze"),
        array("8B847E", "Schooner"),
        array("8B8680", "Natural Gray"),
        array("8B9C90", "Mantle"),
        array("8B9FEE", "Portage"),
        array("8BA690", "Envy"),
        array("8BA9A5", "Cascade"),
        array("8BE6D8", "Riptide"),
        array("8C055E", "Cardinal Pink"),
        array("8C472F", "Mule Fawn"),
        array("8C5738", "Potters Clay"),
        array("8C6495", "Trendy Pink"),
        array("8D0226", "Paprika"),
        array("8D3D38", "Sanguine Brown"),
        array("8D3F3F", "Tosca"),
        array("8D7662", "Cement"),
        array("8D8974", "Granite Green"),
        array("8D90A1", "Manatee"),
        array("8DA8CC", "Polo Blue"),
        array("8E0000", "Red Berry"),
        array("8E4D1E", "Rope"),
        array("8E6F70", "Opium"),
        array("8E775E", "Domino"),
        array("8E8190", "Mamba"),
        array("8EABC1", "Nepal"),
        array("8F021C", "Pohutukawa"),
        array("8F3E33", "El Salva"),
        array("8F4B0E", "Korma"),
        array("8F8176", "Squirrel"),
        array("8FD6B4", "Vista Blue"),
        array("900020", "Burgundy"),
        array("901E1E", "Old Brick"),
        array("907874", "Hemp"),
        array("907B71", "Almond Frost"),
        array("908D39", "Sycamore"),
        array("92000A", "Sangria"),
        array("924321", "Cumin"),
        array("926F5B", "Beaver"),
        array("928573", "Stonewall"),
        array("928590", "Venus"),
        array("9370DB", "Medium Purple"),
        array("93CCEA", "Cornflower"),
        array("93DFB8", "Algae Green"),
        array("944747", "Copper Rust"),
        array("948771", "Arrowtown"),
        array("950015", "Scarlett"),
        array("956387", "Strikemaster"),
        array("959396", "Mountain Mist"),
        array("960018", "Carmine"),
        array("964B00", "Brown"),
        array("967059", "Leather"),
        array("9678B6", "Purple Mountain's Majesty"),
        array("967BB6", "Lavender Purple"),
        array("96A8A1", "Pewter"),
        array("96BBAB", "Summer Green"),
        array("97605D", "Au Chico"),
        array("9771B5", "Wisteria"),
        array("97CD2D", "Atlantis"),
        array("983D61", "Vin Rouge"),
        array("9874D3", "Lilac Bush"),
        array("98777B", "Bazaar"),
        array("98811B", "Hacienda"),
        array("988D77", "Pale Oyster"),
        array("98FF98", "Mint Green"),
        array("990066", "Fresh Eggplant"),
        array("991199", "Violet Eggplant"),
        array("991613", "Tamarillo"),
        array("991B07", "Totem Pole"),
        array("996666", "Copper Rose"),
        array("9966CC", "Amethyst"),
        array("997A8D", "Mountbatten Pink"),
        array("9999CC", "Blue Bell"),
        array("9A3820", "Prairie Sand"),
        array("9A6E61", "Toast"),
        array("9A9577", "Gurkha"),
        array("9AB973", "Olivine"),
        array("9AC2B8", "Shadow Green"),
        array("9B4703", "Oregon"),
        array("9B9E8F", "Lemon Grass"),
        array("9C3336", "Stiletto"),
        array("9D5616", "Hawaiian Tan"),
        array("9DACB7", "Gull Gray"),
        array("9DC209", "Pistachio"),
        array("9DE093", "Granny Smith Apple"),
        array("9DE5FF", "Anakiwa"),
        array("9E5302", "Chelsea Gem"),
        array("9E5B40", "Sepia Skin"),
        array("9EA587", "Sage"),
        array("9EA91F", "Citron"),
        array("9EB1CD", "Rock Blue"),
        array("9EDEE0", "Morning Glory"),
        array("9F381D", "Cognac"),
        array("9F821C", "Reef Gold"),
        array("9F9F9C", "Star Dust"),
        array("9FA0B1", "Santas Gray"),
        array("9FD7D3", "Sinbad"),
        array("9FDD8C", "Feijoa"),
        array("A02712", "Tabasco"),
        array("A1750D", "Buttered Rum"),
        array("A1ADB5", "Hit Gray"),
        array("A1C50A", "Citrus"),
        array("A1DAD7", "Aqua Island"),
        array("A1E9DE", "Water Leaf"),
        array("A2006D", "Flirt"),
        array("A23B6C", "Rouge"),
        array("A26645", "Cape Palliser"),
        array("A2AAB3", "Gray Chateau"),
        array("A2AEAB", "Edward"),
        array("A3807B", "Pharlap"),
        array("A397B4", "Amethyst Smoke"),
        array("A3E3ED", "Blizzard Blue"),
        array("A4A49D", "Delta"),
        array("A4A6D3", "Wistful"),
        array("A4AF6E", "Green Smoke"),
        array("A50B5E", "Jazzberry Jam"),
        array("A59B91", "Zorba"),
        array("A5CB0C", "Bahia"),
        array("A62F20", "Roof Terracotta"),
        array("A65529", "Paarl"),
        array("A68B5B", "Barley Corn"),
        array("A69279", "Donkey Brown"),
        array("A6A29A", "Dawn"),
        array("A72525", "Mexican Red"),
        array("A7882C", "Luxor Gold"),
        array("A85307", "Rich Gold"),
        array("A86515", "Reno Sand"),
        array("A86B6B", "Coral Tree"),
        array("A8989B", "Dusty Gray"),
        array("A899E6", "Dull Lavender"),
        array("A8A589", "Tallow"),
        array("A8AE9C", "Bud"),
        array("A8AF8E", "Locust"),
        array("A8BD9F", "Norway"),
        array("A8E3BD", "Chinook"),
        array("A9A491", "Gray Olive"),
        array("A9ACB6", "Aluminium"),
        array("A9B2C3", "Cadet Blue"),
        array("A9B497", "Schist"),
        array("A9BDBF", "Tower Gray"),
        array("A9BEF2", "Perano"),
        array("A9C6C2", "Opal"),
        array("AA375A", "Night Shadz"),
        array("AA4203", "Fire"),
        array("AA8B5B", "Muesli"),
        array("AA8D6F", "Sandal"),
        array("AAA5A9", "Shady Lady"),
        array("AAA9CD", "Logan"),
        array("AAABB7", "Spun Pearl"),
        array("AAD6E6", "Regent St Blue"),
        array("AAF0D1", "Magic Mint"),
        array("AB0563", "Lipstick"),
        array("AB3472", "Royal Heath"),
        array("AB917A", "Sandrift"),
        array("ABA0D9", "Cold Purple"),
        array("ABA196", "Bronco"),
        array("AC8A56", "Limed Oak"),
        array("AC91CE", "East Side"),
        array("AC9E22", "Lemon Ginger"),
        array("ACA494", "Napa"),
        array("ACA586", "Hillary"),
        array("ACA59F", "Cloudy"),
        array("ACACAC", "Silver Chalice"),
        array("ACB78E", "Swamp Green"),
        array("ACCBB1", "Spring Rain"),
        array("ACDD4D", "Conifer"),
        array("ACE1AF", "Celadon"),
        array("AD781B", "Mandalay"),
        array("ADBED1", "Casper"),
        array("ADDFAD", "Moss Green"),
        array("ADE6C4", "Padua"),
        array("ADFF2F", "Green Yellow"),
        array("AE4560", "Hippie Pink"),
        array("AE6020", "Desert"),
        array("AE809E", "Bouquet"),
        array("AF4035", "Medium Carmine"),
        array("AF4D43", "Apple Blossom"),
        array("AF593E", "Brown Rust"),
        array("AF8751", "Driftwood"),
        array("AF8F2C", "Alpine"),
        array("AF9F1C", "Lucky"),
        array("AFA09E", "Martini"),
        array("AFB1B8", "Bombay"),
        array("AFBDD9", "Pigeon Post"),
        array("B04C6A", "Cadillac"),
        array("B05D54", "Matrix"),
        array("B05E81", "Tapestry"),
        array("B06608", "Mai Tai"),
        array("B09A95", "Del Rio"),
        array("B0E0E6", "Powder Blue"),
        array("B0E313", "Inch Worm"),
        array("B10000", "Bright Red"),
        array("B14A0B", "Vesuvius"),
        array("B1610B", "Pumpkin Skin"),
        array("B16D52", "Santa Fe"),
        array("B19461", "Teak"),
        array("B1E2C1", "Fringy Flower"),
        array("B1F4E7", "Ice Cold"),
        array("B20931", "Shiraz"),
        array("B2A1EA", "Biloba Flower"),
        array("B32D29", "Tall Poppy"),
        array("B35213", "Fiery Orange"),
        array("B38007", "Hot Toddy"),
        array("B3AF95", "Taupe Gray"),
        array("B3C110", "La Rioja"),
        array("B43332", "Well Read"),
        array("B44668", "Blush"),
        array("B4CFD3", "Jungle Mist"),
        array("B57281", "Turkish Rose"),
        array("B57EDC", "Lavender"),
        array("B5A27F", "Mongoose"),
        array("B5B35C", "Olive Green"),
        array("B5D2CE", "Jet Stream"),
        array("B5ECDF", "Cruise"),
        array("B6316C", "Hibiscus"),
        array("B69D98", "Thatch"),
        array("B6B095", "Heathered Gray"),
        array("B6BAA4", "Eagle"),
        array("B6D1EA", "Spindle"),
        array("B6D3BF", "Gum Leaf"),
        array("B7410E", "Rust"),
        array("B78E5C", "Muddy Waters"),
        array("B7A214", "Sahara"),
        array("B7A458", "Husk"),
        array("B7B1B1", "Nobel"),
        array("B7C3D0", "Heather"),
        array("B7F0BE", "Madang"),
        array("B81104", "Milano Red"),
        array("B87333", "Copper"),
        array("B8B56A", "Gimblet"),
        array("B8C1B1", "Green Spring"),
        array("B8C25D", "Celery"),
        array("B8E0F9", "Sail"),
        array("B94E48", "Chestnut"),
        array("B95140", "Crail"),
        array("B98D28", "Marigold"),
        array("B9C46A", "Wild Willow"),
        array("B9C8AC", "Rainee"),
        array("BA0101", "Guardsman Red"),
        array("BA450C", "Rock Spray"),
        array("BA6F1E", "Bourbon"),
        array("BA7F03", "Pirate Gold"),
        array("BAB1A2", "Nomad"),
        array("BAC7C9", "Submarine"),
        array("BAEEF9", "Charlotte"),
        array("BB3385", "Medium Red Violet"),
        array("BB8983", "Brandy Rose"),
        array("BBD009", "Rio Grande"),
        array("BBD7C1", "Surf"),
        array("BCC9C2", "Powder Ash"),
        array("BD5E2E", "Tuscany"),
        array("BD978E", "Quicksand"),
        array("BDB1A8", "Silk"),
        array("BDB2A1", "Malta"),
        array("BDB3C7", "Chatelle"),
        array("BDBBD7", "Lavender Gray"),
        array("BDBDC6", "French Gray"),
        array("BDC8B3", "Clay Ash"),
        array("BDC9CE", "Loblolly"),
        array("BDEDFD", "French Pass"),
        array("BEA6C3", "London Hue"),
        array("BEB5B7", "Pink Swan"),
        array("BEDE0D", "Fuego"),
        array("BF5500", "Rose of Sharon"),
        array("BFB8B0", "Tide"),
        array("BFBED8", "Blue Haze"),
        array("BFC1C2", "Silver Sand"),
        array("BFC921", "Key Lime Pie"),
        array("BFDBE2", "Ziggurat"),
        array("BFFF00", "Lime"),
        array("C02B18", "Thunderbird"),
        array("C04737", "Mojo"),
        array("C08081", "Old Rose"),
        array("C0C0C0", "Silver"),
        array("C0D3B9", "Pale Leaf"),
        array("C0D8B6", "Pixie Green"),
        array("C1440E", "Tia Maria"),
        array("C154C1", "Fuchsia Pink"),
        array("C1A004", "Buddha Gold"),
        array("C1B7A4", "Bison Hide"),
        array("C1BAB0", "Tea"),
        array("C1BECD", "Gray Suit"),
        array("C1D7B0", "Sprout"),
        array("C1F07C", "Sulu"),
        array("C26B03", "Indochine"),
        array("C2955D", "Twine"),
        array("C2BDB6", "Cotton Seed"),
        array("C2CAC4", "Pumice"),
        array("C2E8E5", "Jagged Ice"),
        array("C32148", "Maroon Flush"),
        array("C3B091", "Indian Khaki"),
        array("C3BFC1", "Pale Slate"),
        array("C3C3BD", "Gray Nickel"),
        array("C3CDE6", "Periwinkle Gray"),
        array("C3D1D1", "Tiara"),
        array("C3DDF9", "Tropical Blue"),
        array("C41E3A", "Cardinal"),
        array("C45655", "Fuzzy Wuzzy Brown"),
        array("C45719", "Orange Roughy"),
        array("C4C4BC", "Mist Gray"),
        array("C4D0B0", "Coriander"),
        array("C4F4EB", "Mint Tulip"),
        array("C54B8C", "Mulberry"),
        array("C59922", "Nugget"),
        array("C5994B", "Tussock"),
        array("C5DBCA", "Sea Mist"),
        array("C5E17A", "Yellow Green"),
        array("C62D42", "Brick Red"),
        array("C6726B", "Contessa"),
        array("C69191", "Oriental Pink"),
        array("C6A84B", "Roti"),
        array("C6C3B5", "Ash"),
        array("C6C8BD", "Kangaroo"),
        array("C6E610", "Las Palmas"),
        array("C7031E", "Monza"),
        array("C71585", "Red Violet"),
        array("C7BCA2", "Coral Reef"),
        array("C7C1FF", "Melrose"),
        array("C7C4BF", "Cloud"),
        array("C7C9D5", "Ghost"),
        array("C7CD90", "Pine Glade"),
        array("C7DDE5", "Botticelli"),
        array("C88A65", "Antique Brass"),
        array("C8A2C8", "Lilac"),
        array("C8A528", "Hokey Pokey"),
        array("C8AABF", "Lily"),
        array("C8B568", "Laser"),
        array("C8E3D7", "Edgewater"),
        array("C96323", "Piper"),
        array("C99415", "Pizza"),
        array("C9A0DC", "Light Wisteria"),
        array("C9B29B", "Rodeo Dust"),
        array("C9B35B", "Sundance"),
        array("C9B93B", "Earls Green"),
        array("C9C0BB", "Silver Rust"),
        array("C9D9D2", "Conch"),
        array("C9FFA2", "Reef"),
        array("C9FFE5", "Aero Blue"),
        array("CA3435", "Flush Mahogany"),
        array("CABB48", "Turmeric"),
        array("CADCD4", "Paris White"),
        array("CAE00D", "Bitter Lemon"),
        array("CAE6DA", "Skeptic"),
        array("CB8FA9", "Viola"),
        array("CBCAB6", "Foggy Gray"),
        array("CBD3B0", "Green Mist"),
        array("CBDBD6", "Nebula"),
        array("CC3333", "Persian Red"),
        array("CC5500", "Burnt Orange"),
        array("CC7722", "Ochre"),
        array("CC8899", "Puce"),
        array("CCCAA8", "Thistle Green"),
        array("CCCCFF", "Periwinkle"),
        array("CCFF00", "Electric Lime"),
        array("CD5700", "Tenn"),
        array("CD5C5C", "Chestnut Rose"),
        array("CD8429", "Brandy Punch"),
        array("CDF4FF", "Onahau"),
        array("CEB98F", "Sorrell Brown"),
        array("CEBABA", "Cold Turkey"),
        array("CEC291", "Yuma"),
        array("CEC7A7", "Chino"),
        array("CFA39D", "Eunry"),
        array("CFB53B", "Old Gold"),
        array("CFDCCF", "Tasman"),
        array("CFE5D2", "Surf Crest"),
        array("CFF9F3", "Humming Bird"),
        array("CFFAF4", "Scandal"),
        array("D05F04", "Red Stage"),
        array("D06DA1", "Hopbush"),
        array("D07D12", "Meteor"),
        array("D0BEF8", "Perfume"),
        array("D0C0E5", "Prelude"),
        array("D0F0C0", "Tea Green"),
        array("D18F1B", "Geebung"),
        array("D1BEA8", "Vanilla"),
        array("D1C6B4", "Soft Amber"),
        array("D1D2CA", "Celeste"),
        array("D1D2DD", "Mischka"),
        array("D1E231", "Pear"),
        array("D2691E", "Hot Cinnamon"),
        array("D27D46", "Raw Sienna"),
        array("D29EAA", "Careys Pink"),
        array("D2B48C", "Tan"),
        array("D2DA97", "Deco"),
        array("D2F6DE", "Blue Romance"),
        array("D2F8B0", "Gossip"),
        array("D3CBBA", "Sisal"),
        array("D3CDC5", "Swirl"),
        array("D47494", "Charm"),
        array("D4B6AF", "Clam Shell"),
        array("D4BF8D", "Straw"),
        array("D4C4A8", "Akaroa"),
        array("D4CD16", "Bird Flower"),
        array("D4D7D9", "Iron"),
        array("D4DFE2", "Geyser"),
        array("D4E2FC", "Hawkes Blue"),
        array("D54600", "Grenadier"),
        array("D591A4", "Can Can"),
        array("D59A6F", "Whiskey"),
        array("D5D195", "Winter Hazel"),
        array("D5F6E3", "Granny Apple"),
        array("D69188", "My Pink"),
        array("D6C562", "Tacha"),
        array("D6CEF6", "Moon Raker"),
        array("D6D6D1", "Quill Gray"),
        array("D6FFDB", "Snowy Mint"),
        array("D7837F", "New York Pink"),
        array("D7C498", "Pavlova"),
        array("D7D0FF", "Fog"),
        array("D84437", "Valencia"),
        array("D87C63", "Japonica"),
        array("D8BFD8", "Thistle"),
        array("D8C2D5", "Maverick"),
        array("D8FCFA", "Foam"),
        array("D94972", "Cabaret"),
        array("D99376", "Burning Sand"),
        array("D9B99B", "Cameo"),
        array("D9D6CF", "Timberwolf"),
        array("D9DCC1", "Tana"),
        array("D9E4F5", "Link Water"),
        array("D9F7FF", "Mabel"),
        array("DA3287", "Cerise"),
        array("DA5B38", "Flame Pea"),
        array("DA6304", "Bamboo"),
        array("DA6A41", "Red Damask"),
        array("DA70D6", "Orchid"),
        array("DA8A67", "Copperfield"),
        array("DAA520", "Golden Grass"),
        array("DAECD6", "Zanah"),
        array("DAF4F0", "Iceberg"),
        array("DAFAFF", "Oyster Bay"),
        array("DB5079", "Cranberry"),
        array("DB9690", "Petite Orchid"),
        array("DB995E", "Di Serria"),
        array("DBDBDB", "Alto"),
        array("DBFFF8", "Frosted Mint"),
        array("DC143C", "Crimson"),
        array("DC4333", "Punch"),
        array("DCB20C", "Galliano"),
        array("DCB4BC", "Blossom"),
        array("DCD747", "Wattle"),
        array("DCD9D2", "Westar"),
        array("DCDDCC", "Moon Mist"),
        array("DCEDB4", "Caper"),
        array("DCF0EA", "Swans Down"),
        array("DDD6D5", "Swiss Coffee"),
        array("DDF9F1", "White Ice"),
        array("DE3163", "Cerise Red"),
        array("DE6360", "Roman"),
        array("DEA681", "Tumbleweed"),
        array("DEBA13", "Gold Tips"),
        array("DEC196", "Brandy"),
        array("DECBC6", "Wafer"),
        array("DED4A4", "Sapling"),
        array("DED717", "Barberry"),
        array("DEE5C0", "Beryl Green"),
        array("DEF5FF", "Pattens Blue"),
        array("DF73FF", "Heliotrope"),
        array("DFBE6F", "Apache"),
        array("DFCD6F", "Chenin"),
        array("DFCFDB", "Lola"),
        array("DFECDA", "Willow Brook"),
        array("DFFF00", "Chartreuse Yellow"),
        array("E0B0FF", "Mauve"),
        array("E0B646", "Anzac"),
        array("E0B974", "Harvest Gold"),
        array("E0C095", "Calico"),
        array("E0FFFF", "Baby Blue"),
        array("E16865", "Sunglo"),
        array("E1BC64", "Equator"),
        array("E1C0C8", "Pink Flare"),
        array("E1E6D6", "Periglacial Blue"),
        array("E1EAD4", "Kidnapper"),
        array("E1F6E8", "Tara"),
        array("E25465", "Mandy"),
        array("E2725B", "Terracotta"),
        array("E28913", "Golden Bell"),
        array("E292C0", "Shocking"),
        array("E29418", "Dixie"),
        array("E29CD2", "Light Orchid"),
        array("E2D8ED", "Snuff"),
        array("E2EBED", "Mystic"),
        array("E2F3EC", "Apple Green"),
        array("E30B5C", "Razzmatazz"),
        array("E32636", "Alizarin Crimson"),
        array("E34234", "Cinnabar"),
        array("E3BEBE", "Cavern Pink"),
        array("E3F5E1", "Peppermint"),
        array("E3F988", "Mindaro"),
        array("E47698", "Deep Blush"),
        array("E49B0F", "Gamboge"),
        array("E4C2D5", "Melanie"),
        array("E4CFDE", "Twilight"),
        array("E4D1C0", "Bone"),
        array("E4D422", "Sunflower"),
        array("E4D5B7", "Grain Brown"),
        array("E4D69B", "Zombie"),
        array("E4F6E7", "Frostee"),
        array("E4FFD1", "Snow Flurry"),
        array("E52B50", "Amaranth"),
        array("E5841B", "Zest"),
        array("E5CCC9", "Dust Storm"),
        array("E5D7BD", "Stark White"),
        array("E5D8AF", "Hampton"),
        array("E5E0E1", "Bon Jour"),
        array("E5E5E5", "Mercury"),
        array("E5F9F6", "Polar"),
        array("E64E03", "Trinidad"),
        array("E6BE8A", "Gold Sand"),
        array("E6BEA5", "Cashmere"),
        array("E6D7B9", "Double Spanish White"),
        array("E6E4D4", "Satin Linen"),
        array("E6F2EA", "Harp"),
        array("E6F8F3", "Off Green"),
        array("E6FFE9", "Hint of Green"),
        array("E6FFFF", "Tranquil"),
        array("E77200", "Mango Tango"),
        array("E7730A", "Christine"),
        array("E79F8C", "Tonys Pink"),
        array("E79FC4", "Kobi"),
        array("E7BCB4", "Rose Fog"),
        array("E7BF05", "Corn"),
        array("E7CD8C", "Putty"),
        array("E7ECE6", "Gray Nurse"),
        array("E7F8FF", "Lily White"),
        array("E7FEFF", "Bubbles"),
        array("E89928", "Fire Bush"),
        array("E8B9B3", "Shilo"),
        array("E8E0D5", "Pearl Bush"),
        array("E8EBE0", "Green White"),
        array("E8F1D4", "Chrome White"),
        array("E8F2EB", "Gin"),
        array("E8F5F2", "Aqua Squeeze"),
        array("E96E00", "Clementine"),
        array("E97451", "Burnt Sienna"),
        array("E97C07", "Tahiti Gold"),
        array("E9CECD", "Oyster Pink"),
        array("E9D75A", "Confetti"),
        array("E9E3E3", "Ebb"),
        array("E9F8ED", "Ottoman"),
        array("E9FFFD", "Clear Day"),
        array("EA88A8", "Carissma"),
        array("EAAE69", "Porsche"),
        array("EAB33B", "Tulip Tree"),
        array("EAC674", "Rob Roy"),
        array("EADAB8", "Raffia"),
        array("EAE8D4", "White Rock"),
        array("EAF6EE", "Panache"),
        array("EAF6FF", "Solitude"),
        array("EAF9F5", "Aqua Spring"),
        array("EAFFFE", "Dew"),
        array("EB9373", "Apricot"),
        array("EBC2AF", "Zinnwaldite"),
        array("ECA927", "Fuel Yellow"),
        array("ECC54E", "Ronchi"),
        array("ECC7EE", "French Lilac"),
        array("ECCDB9", "Just Right"),
        array("ECE090", "Wild Rice"),
        array("ECEBBD", "Fall Green"),
        array("ECEBCE", "Aths Special"),
        array("ECF245", "Starship"),
        array("ED0A3F", "Red Ribbon"),
        array("ED7A1C", "Tango"),
        array("ED9121", "Carrot Orange"),
        array("ED989E", "Sea Pink"),
        array("EDB381", "Tacao"),
        array("EDC9AF", "Desert Sand"),
        array("EDCDAB", "Pancho"),
        array("EDDCB1", "Chamois"),
        array("EDEA99", "Primrose"),
        array("EDF5DD", "Frost"),
        array("EDF5F5", "Aqua Haze"),
        array("EDF6FF", "Zumthor"),
        array("EDF9F1", "Narvik"),
        array("EDFC84", "Honeysuckle"),
        array("EE82EE", "Lavender Magenta"),
        array("EEC1BE", "Beauty Bush"),
        array("EED794", "Chalky"),
        array("EED9C4", "Almond"),
        array("EEDC82", "Flax"),
        array("EEDEDA", "Bizarre"),
        array("EEE3AD", "Double Colonial White"),
        array("EEEEE8", "Cararra"),
        array("EEEF78", "Manz"),
        array("EEF0C8", "Tahuna Sands"),
        array("EEF0F3", "Athens Gray"),
        array("EEF3C3", "Tusk"),
        array("EEF4DE", "Loafer"),
        array("EEF6F7", "Catskill White"),
        array("EEFDFF", "Twilight Blue"),
        array("EEFF9A", "Jonquil"),
        array("EEFFE2", "Rice Flower"),
        array("EF863F", "Jaffa"),
        array("EFEFEF", "Gallery"),
        array("EFF2F3", "Porcelain"),
        array("F091A9", "Mauvelous"),
        array("F0D52D", "Golden Dream"),
        array("F0DB7D", "Golden Sand"),
        array("F0DC82", "Buff"),
        array("F0E2EC", "Prim"),
        array("F0E68C", "Khaki"),
        array("F0EEFD", "Selago"),
        array("F0EEFF", "Titan White"),
        array("F0F8FF", "Alice Blue"),
        array("F0FCEA", "Feta"),
        array("F18200", "Gold Drop"),
        array("F19BAB", "Wewak"),
        array("F1E788", "Sahara Sand"),
        array("F1E9D2", "Parchment"),
        array("F1E9FF", "Blue Chalk"),
        array("F1EEC1", "Mint Julep"),
        array("F1F1F1", "Seashell"),
        array("F1F7F2", "Saltpan"),
        array("F1FFAD", "Tidal"),
        array("F1FFC8", "Chiffon"),
        array("F2552A", "Flamingo"),
        array("F28500", "Tangerine"),
        array("F2C3B2", "Mandys Pink"),
        array("F2F2F2", "Concrete"),
        array("F2FAFA", "Black Squeeze"),
        array("F34723", "Pomegranate"),
        array("F3AD16", "Buttercup"),
        array("F3D69D", "New Orleans"),
        array("F3D9DF", "Vanilla Ice"),
        array("F3E7BB", "Sidecar"),
        array("F3E9E5", "Dawn Pink"),
        array("F3EDCF", "Wheatfield"),
        array("F3FB62", "Canary"),
        array("F3FBD4", "Orinoco"),
        array("F3FFD8", "Carla"),
        array("F400A1", "Hollywood Cerise"),
        array("F4A460", "Sandy brown"),
        array("F4C430", "Saffron"),
        array("F4D81C", "Ripe Lemon"),
        array("F4EBD3", "Janna"),
        array("F4F2EE", "Pampas"),
        array("F4F4F4", "Wild Sand"),
        array("F4F8FF", "Zircon"),
        array("F57584", "Froly"),
        array("F5C85C", "Cream Can"),
        array("F5C999", "Manhattan"),
        array("F5D5A0", "Maize"),
        array("F5DEB3", "Wheat"),
        array("F5E7A2", "Sandwisp"),
        array("F5E7E2", "Pot Pourri"),
        array("F5E9D3", "Albescent White"),
        array("F5EDEF", "Soft Peach"),
        array("F5F3E5", "Ecru White"),
        array("F5F5DC", "Beige"),
        array("F5FB3D", "Golden Fizz"),
        array("F5FFBE", "Australian Mint"),
        array("F64A8A", "French Rose"),
        array("F653A6", "Brilliant Rose"),
        array("F6A4C9", "Illusion"),
        array("F6F0E6", "Merino"),
        array("F6F7F7", "Black Haze"),
        array("F6FFDC", "Spring Sun"),
        array("F7468A", "Violet Red"),
        array("F77703", "Chilean Fire"),
        array("F77FBE", "Persian Pink"),
        array("F7B668", "Rajah"),
        array("F7C8DA", "Azalea"),
        array("F7DBE6", "We Peep"),
        array("F7F2E1", "Quarter Spanish White"),
        array("F7F5FA", "Whisper"),
        array("F7FAF7", "Snow Drift"),
        array("F8B853", "Casablanca"),
        array("F8C3DF", "Chantilly"),
        array("F8D9E9", "Cherub"),
        array("F8DB9D", "Marzipan"),
        array("F8DD5C", "Energy Yellow"),
        array("F8E4BF", "Givry"),
        array("F8F0E8", "White Linen"),
        array("F8F4FF", "Magnolia"),
        array("F8F6F1", "Spring Wood"),
        array("F8F7DC", "Coconut Cream"),
        array("F8F7FC", "White Lilac"),
        array("F8F8F7", "Desert Storm"),
        array("F8F99C", "Texas"),
        array("F8FACD", "Corn Field"),
        array("F8FDD3", "Mimosa"),
        array("F95A61", "Carnation"),
        array("F9BF58", "Saffron Mango"),
        array("F9E0ED", "Carousel Pink"),
        array("F9E4BC", "Dairy Cream"),
        array("F9E663", "Portica"),
        array("F9EAF3", "Amour"),
        array("F9F8E4", "Rum Swizzle"),
        array("F9FF8B", "Dolly"),
        array("F9FFF6", "Sugar Cane"),
        array("FA7814", "Ecstasy"),
        array("FA9D5A", "Tan Hide"),
        array("FAD3A2", "Corvette"),
        array("FADFAD", "Peach Yellow"),
        array("FAE600", "Turbo"),
        array("FAEAB9", "Astra"),
        array("FAECCC", "Champagne"),
        array("FAF0E6", "Linen"),
        array("FAF3F0", "Fantasy"),
        array("FAF7D6", "Citrine White"),
        array("FAFAFA", "Alabaster"),
        array("FAFDE4", "Hint of Yellow"),
        array("FAFFA4", "Milan"),
        array("FB607F", "Brink Pink"),
        array("FB8989", "Geraldine"),
        array("FBA0E3", "Lavender Rose"),
        array("FBA129", "Sea Buckthorn"),
        array("FBAC13", "Sun"),
        array("FBAED2", "Lavender Pink"),
        array("FBB2A3", "Rose Bud"),
        array("FBBEDA", "Cupid"),
        array("FBCCE7", "Classic Rose"),
        array("FBCEB1", "Apricot Peach"),
        array("FBE7B2", "Banana Mania"),
        array("FBE870", "Marigold Yellow"),
        array("FBE96C", "Festival"),
        array("FBEA8C", "Sweet Corn"),
        array("FBEC5D", "Candy Corn"),
        array("FBF9F9", "Hint of Red"),
        array("FBFFBA", "Shalimar"),
        array("FC0FC0", "Shocking Pink"),
        array("FC80A5", "Tickle Me Pink"),
        array("FC9C1D", "Tree Poppy"),
        array("FCC01E", "Lightning Yellow"),
        array("FCD667", "Goldenrod"),
        array("FCD917", "Candlelight"),
        array("FCDA98", "Cherokee"),
        array("FCF4D0", "Double Pearl Lusta"),
        array("FCF4DC", "Pearl Lusta"),
        array("FCF8F7", "Vista White"),
        array("FCFBF3", "Bianca"),
        array("FCFEDA", "Moon Glow"),
        array("FCFFE7", "China Ivory"),
        array("FCFFF9", "Ceramic"),
        array("FD0E35", "Torch Red"),
        array("FD5B78", "Wild Watermelon"),
        array("FD7B33", "Crusta"),
        array("FD7C07", "Sorbus"),
        array("FD9FA2", "Sweet Pink"),
        array("FDD5B1", "Light Apricot"),
        array("FDD7E4", "Pig Pink"),
        array("FDE1DC", "Cinderella"),
        array("FDE295", "Golden Glow"),
        array("FDE910", "Lemon"),
        array("FDF5E6", "Old Lace"),
        array("FDF6D3", "Half Colonial White"),
        array("FDF7AD", "Drover"),
        array("FDFEB8", "Pale Prim"),
        array("FDFFD5", "Cumulus"),
        array("FE28A2", "Persian Rose"),
        array("FE4C40", "Sunset Orange"),
        array("FE6F5E", "Bittersweet"),
        array("FE9D04", "California"),
        array("FEA904", "Yellow Sea"),
        array("FEBAAD", "Melon"),
        array("FED33C", "Bright Sun"),
        array("FED85D", "Dandelion"),
        array("FEDB8D", "Salomie"),
        array("FEE5AC", "Cape Honey"),
        array("FEEBF3", "Remy"),
        array("FEEFCE", "Oasis"),
        array("FEF0EC", "Bridesmaid"),
        array("FEF2C7", "Beeswax"),
        array("FEF3D8", "Bleach White"),
        array("FEF4CC", "Pipi"),
        array("FEF4DB", "Half Spanish White"),
        array("FEF4F8", "Wisp Pink"),
        array("FEF5F1", "Provincial Pink"),
        array("FEF7DE", "Half Dutch White"),
        array("FEF8E2", "Solitaire"),
        array("FEF8FF", "White Pointer"),
        array("FEF9E3", "Off Yellow"),
        array("FEFCED", "Orange White"),
        array("FF0000", "Red"),
        array("FF007F", "Rose"),
        array("FF00CC", "Purple Pizzazz"),
        array("FF00FF", "Magenta / Fuchsia"),
        array("FF2400", "Scarlet"),
        array("FF3399", "Wild Strawberry"),
        array("FF33CC", "Razzle Dazzle Rose"),
        array("FF355E", "Radical Red"),
        array("FF3F34", "Red Orange"),
        array("FF4040", "Coral Red"),
        array("FF4D00", "Vermilion"),
        array("FF4F00", "International Orange"),
        array("FF6037", "Outrageous Orange"),
        array("FF6600", "Blaze Orange"),
        array("FF66FF", "Pink Flamingo"),
        array("FF681F", "Orange"),
        array("FF69B4", "Hot Pink"),
        array("FF6B53", "Persimmon"),
        array("FF6FFF", "Blush Pink"),
        array("FF7034", "Burning Orange"),
        array("FF7518", "Pumpkin"),
        array("FF7D07", "Flamenco"),
        array("FF7F00", "Flush Orange"),
        array("FF7F50", "Coral"),
        array("FF8C69", "Salmon"),
        array("FF9000", "Pizazz"),
        array("FF910F", "West Side"),
        array("FF91A4", "Pink Salmon"),
        array("FF9933", "Neon Carrot"),
        array("FF9966", "Atomic Tangerine"),
        array("FF9980", "Vivid Tangerine"),
        array("FF9E2C", "Sunshade"),
        array("FFA000", "Orange Peel"),
        array("FFA194", "Mona Lisa"),
        array("FFA500", "Web Orange"),
        array("FFA6C9", "Carnation Pink"),
        array("FFAB81", "Hit Pink"),
        array("FFAE42", "Yellow Orange"),
        array("FFB0AC", "Cornflower Lilac"),
        array("FFB1B3", "Sundown"),
        array("FFB31F", "My Sin"),
        array("FFB555", "Texas Rose"),
        array("FFB7D5", "Cotton Candy"),
        array("FFB97B", "Macaroni and Cheese"),
        array("FFBA00", "Selective Yellow"),
        array("FFBD5F", "Koromiko"),
        array("FFBF00", "Amber"),
        array("FFC0A8", "Wax Flower"),
        array("FFC0CB", "Pink"),
        array("FFC3C0", "Your Pink"),
        array("FFC901", "Supernova"),
        array("FFCBA4", "Flesh"),
        array("FFCC33", "Sunglow"),
        array("FFCC5C", "Golden Tainoi"),
        array("FFCC99", "Peach Orange"),
        array("FFCD8C", "Chardonnay"),
        array("FFD1DC", "Pastel Pink"),
        array("FFD2B7", "Romantic"),
        array("FFD38C", "Grandis"),
        array("FFD700", "Gold"),
        array("FFD800", "School bus Yellow"),
        array("FFD8D9", "Cosmos"),
        array("FFDB58", "Mustard"),
        array("FFDCD6", "Peach Schnapps"),
        array("FFDDAF", "Caramel"),
        array("FFDDCD", "Tuft Bush"),
        array("FFDDCF", "Watusi"),
        array("FFDDF4", "Pink Lace"),
        array("FFDEAD", "Navajo White"),
        array("FFDEB3", "Frangipani"),
        array("FFE1DF", "Pippin"),
        array("FFE1F2", "Pale Rose"),
        array("FFE2C5", "Negroni"),
        array("FFE5A0", "Cream Brulee"),
        array("FFE5B4", "Peach"),
        array("FFE6C7", "Tequila"),
        array("FFE772", "Kournikova"),
        array("FFEAC8", "Sandy Beach"),
        array("FFEAD4", "Karry"),
        array("FFEC13", "Broom"),
        array("FFEDBC", "Colonial White"),
        array("FFEED8", "Derby"),
        array("FFEFA1", "Vis Vis"),
        array("FFEFC1", "Egg White"),
        array("FFEFD5", "Papaya Whip"),
        array("FFEFEC", "Fair Pink"),
        array("FFF0DB", "Peach Cream"),
        array("FFF0F5", "Lavender blush"),
        array("FFF14F", "Gorse"),
        array("FFF1B5", "Buttermilk"),
        array("FFF1D8", "Pink Lady"),
        array("FFF1EE", "Forget Me Not"),
        array("FFF1F9", "Tutu"),
        array("FFF39D", "Picasso"),
        array("FFF3F1", "Chardon"),
        array("FFF46E", "Paris Daisy"),
        array("FFF4CE", "Barley White"),
        array("FFF4DD", "Egg Sour"),
        array("FFF4E0", "Sazerac"),
        array("FFF4E8", "Serenade"),
        array("FFF4F3", "Chablis"),
        array("FFF5EE", "Seashell Peach"),
        array("FFF5F3", "Sauvignon"),
        array("FFF6D4", "Milk Punch"),
        array("FFF6DF", "Varden"),
        array("FFF6F5", "Rose White"),
        array("FFF8D1", "Baja White"),
        array("FFF9E2", "Gin Fizz"),
        array("FFF9E6", "Early Dawn"),
        array("FFFACD", "Lemon Chiffon"),
        array("FFFAF4", "Bridal Heath"),
        array("FFFBDC", "Scotch Mist"),
        array("FFFBF9", "Soapstone"),
        array("FFFC99", "Witch Haze"),
        array("FFFCEA", "Buttery White"),
        array("FFFCEE", "Island Spice"),
        array("FFFDD0", "Cream"),
        array("FFFDE6", "Chilean Heath"),
        array("FFFDE8", "Travertine"),
        array("FFFDF3", "Orchid White"),
        array("FFFDF4", "Quarter Pearl Lusta"),
        array("FFFEE1", "Half and Half"),
        array("FFFEEC", "Apricot White"),
        array("FFFEF0", "Rice Cake"),
        array("FFFEF6", "Black White"),
        array("FFFEFD", "Romance"),
        array("FFFF00", "Yellow"),
        array("FFFF66", "Laser Lemon"),
        array("FFFF99", "Pale Canary"),
        array("FFFFB4", "Portafino"),
        array("FFFFF0", "Ivory"),
        array("FFFFFF", "White")
    );
}